/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class SignRenderer<T extends SignBlockPart<T>>
extends BlockPartRenderer<T> {
    protected abstract QuadModel makeMainModel(T var1);

    protected abstract QuadModel makeSecondaryModel(T var1);

    protected abstract QuadModel makeBakedOverlayModel(T var1, Overlay var2);

    @Override
    public void render(T sign, class_1937 level, class_2338 pos, class_4587 blockToView, class_11659 nodeCollector, class_11701 materials, int combinedLights, int combinedOverlay, Function<class_2960, class_1921> renderTypeFactory, class_11683.class_11792 crumblingOverlay) {
        if (((SignBlockPart)sign).isMarkedForGeneration() && !IConfig.IServer.getInstance().worldGen().debugMode()) {
            return;
        }
        RenderingUtil.wrapInMatrixEntry(blockToView, () -> {
            Quaternionf rotation = new Quaternionf(new AxisAngle4f(sign.getAngle().get().radians(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            blockToView.method_22907((Quaternionfc)rotation);
            RenderingUtil.wrapInMatrixEntry(blockToView, () -> {
                blockToView.method_22907((Quaternionfc)new Quaternionf(new AxisAngle4f((float)Math.PI, (Vector3fc)(sign.isFlipped() ? new Vector3f(0.0f, 0.0f, 1.0f) : new Vector3f(1.0f, 0.0f, 0.0f)))));
                this.renderText(sign, blockToView, class_310.method_1551().field_1772, nodeCollector, combinedLights);
            });
            RenderingUtil.render(blockToView, new TexturedModel(this.makeMainModel(sign), sign.getMainTexture().toMaterial(), sign.getMainTexture().tint().map(t -> t.getColorAt((class_1920)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
            RenderingUtil.render(blockToView, new TexturedModel(this.makeSecondaryModel(sign), sign.getSecondaryTexture().toMaterial(), sign.getSecondaryTexture().tint().map(t -> t.getColorAt((class_1920)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
            sign.getOverlay().ifPresent(o -> RenderingUtil.render(blockToView, new TexturedModel(this.makeBakedOverlayModel(sign, (Overlay)o), o.materialFor(sign.getClass()), o.tint.map(t -> t.getColorAt((class_1920)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay));
        });
    }

    protected abstract void renderText(T var1, class_4587 var2, class_327 var3, class_11659 var4, int var5);
}

