/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.compat;

import com.mojang.serialization.MapCodec;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.utils.EventDispatcher;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_9139;

public class ExternalWaystoneLibrary {
    private static final EventDispatcher.Impl.WithPublicDispatch<ExternalWaystoneLibrary> _onInitialize = new EventDispatcher.Impl.WithPublicDispatch();
    private static ExternalWaystoneLibrary instance;
    private final List<Adapter> adapters = new ArrayList<Adapter>();

    public static EventDispatcher<ExternalWaystoneLibrary> onInitialize() {
        return _onInitialize;
    }

    public static ExternalWaystoneLibrary getInstance() {
        return instance;
    }

    private ExternalWaystoneLibrary() {
    }

    public static void initialize() {
        instance = new ExternalWaystoneLibrary();
        _onInitialize.dispatch(instance, false);
    }

    public Optional<MapCodec<? extends WaystoneHandle>> getCodec(String type) {
        for (Adapter adapter : this.adapters) {
            if (!adapter.typeTag().equals(type)) continue;
            return Optional.of(adapter.getCodec());
        }
        return Optional.empty();
    }

    public Optional<class_9139<ByteBuf, ? extends WaystoneHandle>> getStreamCodec(String type) {
        for (Adapter adapter : this.adapters) {
            if (!adapter.typeTag().equals(type)) continue;
            return Optional.of(adapter.getStreamCodec());
        }
        return Optional.empty();
    }

    public void registerAdapter(Adapter adapter) {
        this.adapters.add(adapter);
    }

    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        for (Adapter adapter : this.adapters) {
            adapter.requestKnownWaystones(consumer);
        }
    }

    public Optional<ExternalWaystone> getData(WaystoneHandle handle) {
        return this.adapters.stream().flatMap(a -> a.getData(handle).stream()).findFirst();
    }

    public Optional<class_2561> cannotTeleportToBecause(class_1657 player, WaystoneHandle handle) {
        return this.adapters.stream().flatMap(a -> a.cannotTeleportToBecause(player, handle).stream()).findFirst();
    }

    public static interface Adapter {
        public String typeTag();

        public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> var1);

        public Optional<ExternalWaystone> getData(WaystoneHandle var1);

        public Optional<class_2561> cannotTeleportToBecause(class_1657 var1, WaystoneHandle var2);

        public MapCodec<? extends WaystoneHandle> getCodec();

        public class_9139<ByteBuf, ? extends WaystoneHandle> getStreamCodec();
    }
}

