/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.compat;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public final class WaystonesAdapter
implements ExternalWaystoneLibrary.Adapter {
    private static WaystonesAdapter instance;
    private final EventDispatcher.Impl.WithPublicDispatch<Collection<ExternalWaystone>> onReply = new EventDispatcher.Impl.WithPublicDispatch();
    private static final String notActivatedKey = "gui.waystones.inventory.no_waystones_activated";

    private WaystonesAdapter() {
    }

    public static void register() {
        instance = new WaystonesAdapter();
        ExternalWaystoneLibrary.onInitialize().addListener(ex -> ex.registerAdapter(instance));
    }

    public static Map<class_2960, PacketHandler.Event<?>> getEvents() {
        HashMap map = new HashMap();
        map.put(class_2960.method_60655((String)"signpost", (String)"waystones_adapter_request"), RequestEvent.INSTANCE);
        map.put(class_2960.method_60655((String)"signpost", (String)"waystones_adapter_reply"), new ReplyEvent());
        return map;
    }

    @Override
    public String typeTag() {
        return "waystones";
    }

    @Override
    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        this.onReply.addListener(consumer);
        PacketHandler.getInstance().sendToServer(RequestEvent.INSTANCE);
    }

    @Override
    public Optional<ExternalWaystone> getData(WaystoneHandle handle) {
        return handle instanceof Handle ? this.getData((Handle)handle).map(w -> w) : Optional.empty();
    }

    private Optional<WaystoneWaystone> getData(Handle handle) {
        return WaystonesAPI.getWaystone((MinecraftServer)Signpost.getServerInstance(), (UUID)handle.id).map(WaystoneWaystone::new);
    }

    @Override
    public Optional<class_2561> cannotTeleportToBecause(class_1657 player, WaystoneHandle handle) {
        if (!(handle instanceof Handle)) {
            return Optional.empty();
        }
        return this.getData((Handle)handle).flatMap(waystone -> waystone.wrapped.getVisibility() == WaystoneVisibility.GLOBAL || PlayerWaystoneManager.isWaystoneActivated((class_1657)player, (Waystone)waystone.wrapped) ? Optional.empty() : Optional.of(class_2561.method_43471((String)notActivatedKey)));
    }

    @Override
    public MapCodec<? extends WaystoneHandle> getCodec() {
        return Handle.CODEC;
    }

    @Override
    public class_9139<ByteBuf, ? extends WaystoneHandle> getStreamCodec() {
        return Handle.STREAM_CODEC;
    }

    public static final class RequestEvent
    implements PacketHandler.Event.ForServer<RequestEvent> {
        public static final RequestEvent INSTANCE = new RequestEvent();

        @Override
        public class_9139<class_9129, RequestEvent> codec() {
            return class_9139.method_56431((Object)INSTANCE);
        }

        @Override
        public Class<RequestEvent> getMessageClass() {
            return RequestEvent.class;
        }

        @Override
        public void handle(RequestEvent message, PacketHandler.Context.Server context) {
            PacketHandler.getInstance().sendToPlayer(context.sender(), new ReplyEvent.Packet(PlayerWaystoneManager.getActivatedWaystones((class_1657)context.sender()).stream().map(WaystoneWaystone::new).collect(Collectors.toList())));
        }
    }

    public static final class ReplyEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystonesAdapter.instance.onReply.dispatch(new ArrayList<WaystoneWaystone>(message.waystones), true);
        }

        public record Packet(Collection<WaystoneWaystone> waystones) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56376(ArrayList::new, (class_9139)WaystoneImpl.STREAM_CODEC.method_56432(WaystoneWaystone::new, WaystoneWaystone::wrapped)), Packet::waystones, Packet::new);
        }
    }

    public record Handle(UUID id) implements ExternalWaystone.Handle
    {
        public static final MapCodec<Handle> CODEC = class_4844.field_25122.xmap(Handle::new, Handle::id).fieldOf("id");
        public static final class_9139<ByteBuf, Handle> STREAM_CODEC = class_4844.field_48453.method_56432(Handle::new, Handle::id);

        @Override
        public String typeTag() {
            return instance.typeTag();
        }

        @Override
        public String modMark() {
            return "(Waystones)";
        }

        @Override
        public String noTeleportLangKey() {
            return "signpost.no_teleport_waystones_mod";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle that = (Handle)o;
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public record WaystoneWaystone(Waystone wrapped) implements ExternalWaystone
    {
        @Override
        public String name() {
            return this.wrapped.getName().getString();
        }

        @Override
        public WaystoneLocationData loc() {
            WorldLocation blockPos = WorldLocation.from(this.wrapped.getPos(), this.wrapped.getDimension().method_29177());
            return new WaystoneLocationData(blockPos, Vector3.fromBlockPos(blockPos.blockPos().method_10093(this.spawnInDirection(blockPos))));
        }

        private class_2350 spawnInDirection(WorldLocation blockPos) {
            class_2680 state;
            class_1937 world = TileEntityUtils.toWorld(blockPos.world(), false).orElse(null);
            class_2680 class_26802 = state = world != null ? world.method_8320(blockPos.blockPos()) : null;
            if (state == null || !state.method_28498((class_2769)WaystoneBlock.FACING)) {
                return class_2350.field_11043;
            }
            class_2350 direction = (class_2350)state.method_11654((class_2769)WaystoneBlock.FACING);
            ArrayList directionCandidates = Lists.newArrayList((Object[])new class_2350[]{direction, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043});
            for (class_2350 candidate : directionCandidates) {
                class_2338 offsetPos = blockPos.blockPos().method_10093(candidate);
                class_2338 offsetPosUp = offsetPos.method_10084();
                if (world.method_8320(offsetPos).method_26228((class_1922)world, offsetPos) || world.method_8320(offsetPosUp).method_26228((class_1922)world, offsetPosUp)) continue;
                return candidate;
            }
            return direction;
        }

        @Override
        public ExternalWaystone.Handle handle() {
            return new Handle(this.wrapped.getWaystoneUid());
        }
    }
}

