/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.config;

import gollorum.signpost.config.PermissionConfig;
import gollorum.signpost.config.TeleportConfig;
import gollorum.signpost.config.WorldGenConfig;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.config.IPermissionConfig;
import gollorum.signpost.minecraft.config.ITeleportConfig;
import gollorum.signpost.minecraft.config.IWorldGenConfig;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;

@me.shedaniel.autoconfig.annotation.Config(name="signpost")
public class Config
implements ConfigData,
IConfig {
    @ConfigEntry.Gui.CollapsibleObject
    public CommonConfig common = new CommonConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public ClientConfig client = new ClientConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public ServerConfig server = new ServerConfig();

    @Override
    public IConfig.IServer getServer() {
        return this.server;
    }

    @Override
    public IConfig.ICommon getCommon() {
        return this.common;
    }

    @Override
    public IConfig.IClient getClient() {
        return this.client;
    }

    public static void register() {
        AutoConfig.register(Config.class, GsonConfigSerializer::new);
    }

    public static Config get() {
        return (Config)AutoConfig.getConfigHolder(Config.class).getConfig();
    }

    public static class CommonConfig
    implements IConfig.ICommon {
        @ConfigEntry.Gui.CollapsibleObject
        public WorldGenConfig worldGen = new WorldGenConfig();
    }

    public static class ClientConfig
    implements IConfig.IClient {
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean enableConfirmationScreen = true;

        @Override
        public boolean enableConfirmationScreen() {
            return this.enableConfirmationScreen;
        }
    }

    public static class ServerConfig
    implements IConfig.IServer {
        @ConfigEntry.Gui.CollapsibleObject
        public TeleportConfig teleport = new TeleportConfig();
        @ConfigEntry.Gui.Tooltip(count=4)
        public List<String> allowedWaystones = ModelWaystone.variants.stream().map(v -> v.name).collect(Collectors.toList());
        @ConfigEntry.Gui.CollapsibleObject
        public PermissionConfig permissions = new PermissionConfig();

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public ITeleportConfig teleport() {
            return this.teleport;
        }

        @Override
        public IWorldGenConfig worldGen() {
            return Config.get().common.worldGen;
        }

        @Override
        public IPermissionConfig permissions() {
            return this.permissions;
        }

        @Override
        public List<? extends String> allowedWaystones() {
            return this.allowedWaystones;
        }
    }
}

