/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.events;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.events.WaystoneAddedEvent;
import gollorum.signpost.events.WaystoneAddedOrRenamedEvent;
import gollorum.signpost.events.WaystoneMovedEvent;
import gollorum.signpost.events.WaystoneRemovedEvent;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class WaystoneUpdatedEvent {
    public final WaystoneLocationData location;
    public final String name;
    public final WaystoneHandle.Vanilla handle;

    public static WaystoneUpdatedEvent fromUpdated(WaystoneLocationData location, String name, Optional<String> oldName, boolean isLocked, WaystoneHandle.Vanilla handle) {
        return oldName.map(n -> new WaystoneRenamedEvent(location, name, (String)n, isLocked, handle)).orElse(new WaystoneAddedEvent(location, name, isLocked, handle));
    }

    public static WaystoneUpdatedEvent fromUpdated(WaystoneLocationData location, String name, boolean isLocked, WaystoneHandle.Vanilla handle) {
        return new WaystoneAddedEvent(location, name, isLocked, handle);
    }

    public WaystoneUpdatedEvent(WaystoneLocationData location, String name, WaystoneHandle.Vanilla handle) {
        this.location = location.withoutExplicitLevel();
        this.name = name;
        this.handle = handle;
    }

    public abstract Type getType();

    public static class Serializer
    implements class_9139<class_2540, WaystoneUpdatedEvent> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void encode(class_2540 buffer, WaystoneUpdatedEvent event) {
            buffer.method_10817((Enum)event.getType());
            WaystoneLocationData.STREAM_CODEC.encode((Object)buffer, (Object)event.location);
            class_9135.field_48554.encode((Object)buffer, (Object)event.name);
            WaystoneHandle.Vanilla.STREAM_CODEC.encode((Object)buffer, (Object)event.handle);
            if (event instanceof WaystoneRenamedEvent) {
                class_9135.field_48554.encode((Object)buffer, (Object)((WaystoneRenamedEvent)event).oldName);
            } else if (event instanceof WaystoneMovedEvent) {
                WorldLocation.STREAM_CODEC.encode((Object)buffer, (Object)((WaystoneMovedEvent)event).newLocation);
            }
            if (event instanceof WaystoneAddedOrRenamedEvent) {
                buffer.method_52964(((WaystoneAddedOrRenamedEvent)event).isLocked);
            }
        }

        public WaystoneUpdatedEvent decode(class_2540 buffer) {
            Type type = (Type)buffer.method_10818(Type.class);
            WaystoneLocationData location = (WaystoneLocationData)WaystoneLocationData.STREAM_CODEC.decode((Object)buffer);
            String name = (String)class_9135.field_48554.decode((Object)buffer);
            WaystoneHandle.Vanilla handle = (WaystoneHandle.Vanilla)WaystoneHandle.Vanilla.STREAM_CODEC.decode((Object)buffer);
            return switch (type.ordinal()) {
                case 0 -> new WaystoneAddedEvent(location, name, buffer.readBoolean(), handle);
                case 1 -> new WaystoneRemovedEvent(location, name, handle);
                case 2 -> new WaystoneRenamedEvent(location, name, (String)class_9135.field_48554.decode((Object)buffer), buffer.readBoolean(), handle);
                case 3 -> new WaystoneMovedEvent(location, (WorldLocation)WorldLocation.STREAM_CODEC.decode((Object)buffer), name, handle);
                default -> throw new RuntimeException("Type " + String.valueOf((Object)type) + " is not supported");
            };
        }
    }

    public static enum Type {
        Added,
        Removed,
        Renamed,
        Moved;

    }
}

