/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class ModelWaystone
extends class_2237
implements class_3737 {
    public static final class_2746 Waterlogged = class_2741.field_12508;
    public static final class_2754<class_2350> Facing = class_2741.field_12481;
    private static final String REGISTRY_NAME = "waystone_model";
    public static final List<Variant> variants = new ArrayList<Variant>();
    public static Variant simple_0 = new Variant("simple_0", "0", class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_1 = new Variant("simple_1", "0", class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_2 = new Variant("simple_2", "0", class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), 0.0f);
    public static Variant detailed_0 = new Variant("detailed_0", "1", class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 2.0f);
    public static Variant detailed_1 = new Variant("detailed_1", "1", class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75), 0.0f);
    public static Variant aer = new Variant("aer", "2", class_259.method_1081((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.6f, (double)0.95f), 0.0f);
    public static Variant dwarf = new Variant("dwarf", "2", class_259.method_1081((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.4375, (double)0.95f), 2.0f);
    public static Variant ygnar = new Variant("ygnar", "2", class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), 0.0f);
    public static final Variant generationMarker = simple_0;
    public final Variant variant;

    public ModelWaystone(Variant variant) {
        this(variant, class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_51368(class_2766.field_12653).method_9629(1.5f, 6.0f).method_22488().method_26245((x, y, z) -> false).method_29292().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"signpost", (String)variant.registryName))));
    }

    public ModelWaystone(Variant variant, class_4970.class_2251 properties) {
        super(properties);
        this.variant = variant;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)Waterlogged, (Comparable)Boolean.valueOf(false))).method_11657(Facing, (Comparable)class_2350.field_11043));
    }

    protected class_1269 method_55765(class_1799 item, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.use(world, pos, player);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return this.use(level, pos, player);
    }

    public class_1269 use(class_1937 world, class_2338 pos, class_1657 player) {
        WaystoneBlock.onRightClick(world, pos, player);
        return class_1269.field_21466;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{Waterlogged}).method_11667(new class_2769[]{Facing});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(Facing, (Comparable)context.method_8042());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)rot.method_10503((class_2350)state.method_11654(Facing)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)((class_2350)state.method_11654(Facing)).method_10153());
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WaystoneTile(pos, state);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)Waterlogged) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9579(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)Waterlogged) == false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.variant.shape;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (!world.method_8608() && world instanceof class_1937) {
            WaystoneTile.onRemoved((class_3218)world, pos);
        }
    }

    protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 itemStack = super.method_9574(level, pos, state, includeData);
        if (includeData) {
            WaystoneBlock.fillClonedItemStack(itemStack, level, pos);
        }
        return itemStack;
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)ModelWaystone.method_54096(), (App)Codec.STRING.fieldOf("variant").forGetter(block -> ((ModelWaystone)block).variant.name)).apply((Applicative)builder, (properties, variantName) -> variants.stream().filter(v -> Objects.equals(v.name, variantName)).findAny().orElseThrow().createBlock(v -> new ModelWaystone((Variant)v, (class_4970.class_2251)properties))));
    }

    static {
        variants.add(simple_0);
        variants.add(simple_1);
        variants.add(simple_2);
        variants.add(detailed_0);
        variants.add(detailed_1);
        variants.add(aer);
        variants.add(dwarf);
        variants.add(ygnar);
    }

    public static class Variant {
        public final String name;
        public final String registryName;
        public final String langPrefix;
        private ModelWaystone block = null;
        public final class_265 shape;
        public final float modelYOffset;

        public Variant(String name, String langPrefix, class_265 shape, float modelYOffset) {
            this.name = name;
            this.registryName = "waystone_model_" + name;
            this.langPrefix = langPrefix;
            this.shape = shape;
            this.modelYOffset = modelYOffset;
        }

        public ModelWaystone createBlock(Function<Variant, ModelWaystone> factory) {
            assert (this.block == null);
            this.block = factory.apply(this);
            return this.block;
        }

        public ModelWaystone getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Variant && this.name.equals(((Variant)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

