/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PropertiesUtil;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public final class PostBlock
extends class_2237
implements class_3737 {
    public static final class_2754<class_2350> Facing = class_2741.field_12481;
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final String REGISTRY_NAME = "post";
    public static final Variant STONE = new Variant(PropertiesUtil.STONE, ModelType.Stone, "stone", Variant.RequiredTool.Pickaxe);
    public static final Variant IRON = new Variant(PropertiesUtil.IRON, ModelType.Iron, "iron", Variant.RequiredTool.Pickaxe);
    public static final Variant OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Oak), ModelType.Oak, "oak", Variant.RequiredTool.Axe);
    public static final Variant DARK_OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.DarkOak), ModelType.DarkOak, "dark_oak", Variant.RequiredTool.Axe);
    public static final Variant SPRUCE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Spruce), ModelType.Spruce, "spruce", Variant.RequiredTool.Axe);
    public static final Variant BIRCH = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Birch), ModelType.Birch, "birch", Variant.RequiredTool.Axe);
    public static final Variant JUNGLE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Jungle), ModelType.Jungle, "jungle", Variant.RequiredTool.Axe);
    public static final Variant ACACIA = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Acacia), ModelType.Acacia, "acacia", Variant.RequiredTool.Axe);
    public static final Variant MANGROVE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Mangrove), ModelType.Mangrove, "mangrove", Variant.RequiredTool.Axe);
    public static final Variant BAMBOO = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Bamboo), ModelType.Bamboo, "bamboo", Variant.RequiredTool.Axe);
    public static final Variant CHERRY = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Cherry), ModelType.Cherry, "cherry", Variant.RequiredTool.Axe);
    public static final Variant WARPED = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Warped), ModelType.Warped, "warped", Variant.RequiredTool.Axe);
    public static final Variant CRIMSON = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Crimson), ModelType.Crimson, "crimson", Variant.RequiredTool.Axe);
    public static final Variant SANDSTONE = new Variant(PropertiesUtil.STONE, ModelType.Sandstone, "sandstone", Variant.RequiredTool.Pickaxe);
    public static final Variant BROWN_MUSHROOM = new Variant(PropertiesUtil.mushroom(class_3620.field_16000), ModelType.BrownMushroom, "brown_mushroom", Variant.RequiredTool.Axe);
    public static final Variant RED_MUSHROOM = new Variant(PropertiesUtil.mushroom(class_3620.field_16020), ModelType.RedMushroom, "red_mushroom", Variant.RequiredTool.Axe);
    public static final List<Variant> AllVariants = Arrays.asList(OAK, BIRCH, SPRUCE, JUNGLE, DARK_OAK, ACACIA, MANGROVE, BAMBOO, CHERRY, STONE, IRON, WARPED, CRIMSON, SANDSTONE, BROWN_MUSHROOM, RED_MUSHROOM);
    public final ModelType type;
    public final Variant variant;

    public boolean method_9543() {
        return true;
    }

    public static class_2248[] getAllBlocks() {
        return (class_2248[])AllVariants.stream().map(Variant::getBlock).toArray(class_2248[]::new);
    }

    public PostBlock(class_4970.class_2251 properties, ModelType type, Variant variant) {
        super(properties.method_22488());
        this.type = type;
        this.variant = variant;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 currentStack) {
        super.method_9567(world, pos, state, placer, currentStack);
        class_1799 stack = currentStack.method_7972();
        IDelay.forFrames(6, world.method_8608(), () -> TileEntityUtils.delayUntilTileEntityExists((class_1936)world, pos, PostTile.getBlockEntityType(), tile -> {
            tile.setSignpostOwner(Optional.of(PlayerHandle.from((class_1297)placer)));
            boolean shouldAddNewSign = placer instanceof class_3222;
            if (!world.method_8608()) {
                PostData customData = (PostData)stack.method_58694(PostData.TYPE);
                if (customData != null) {
                    tile.readData(customData);
                    shouldAddNewSign = false;
                    tile.getWaystonePart().ifPresent(waystone -> WaystoneBlock.registerOwnerAndSeeIfHasName(tile, world, pos, placer, stack));
                } else {
                    tile.addPart(new BlockPartInstance(new PostBlockPart(this.type.postTexture), Vector3.ZERO), class_1799.field_8037, PlayerHandle.from((class_1297)placer));
                }
                tile.method_5431();
                world.method_8413(pos, state, state, 3);
                if (shouldAddNewSign) {
                    PacketHandler.getInstance().sendToPlayer((class_3222)placer, RequestSignGui.ForNewSign.Package.from(WorldLocation.from(pos, world), tile.modelType, new Vector3(0.0f, 1.0f, 0.0f), class_1799.field_8037));
                }
            }
        }, 100, Optional.of(() -> Signpost.LOGGER.error("Could not initialize placed signpost: BlockEntity never appeared."))));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9584(state, world, pos);
    }

    protected class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
        class_2586 t = level.method_8321(pos);
        return t instanceof PostTile ? ((PostTile)t).getBounds() : class_259.method_1073();
    }

    protected class_265 method_26159(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.method_9584(state, level, pos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PostTile(this.type, pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{Facing}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.method_9530(state, worldIn, pos, context);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return this.use(level, pos, player, class_1268.field_5808);
    }

    protected class_1269 method_55765(class_1799 item, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.use(level, blockPos, player, hand);
    }

    public class_1269 use(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1269.class_9860 class_98602;
        class_2586 tileEntity = world.method_8321(pos);
        if (tileEntity instanceof PostTile) {
            PostTile tile = (PostTile)tileEntity;
            class_98602 = PostBlock.onActivate(tile, world, player, hand);
        } else {
            class_98602 = class_1269.field_5812;
        }
        return class_98602;
    }

    public static class_1269 onActivate(PostTile tile, class_1937 world, class_1657 player, class_1268 hand) {
        return switch (tile.trace((class_1297)player).map(p -> p.part.blockPart().interact(new InteractionInfo(InteractionInfo.Type.RightClick, player, hand, tile, (PostTile.TraceResult)p, () -> tile.notifyMutation(p.id, p.part, p.part.blockPart().getMeta().identifier()), world.method_8608()))).orElse(Interactable.InteractionResult.Ignored)) {
            default -> throw new MatchException(null, null);
            case Interactable.InteractionResult.Accepted -> class_1269.field_5812;
            case Interactable.InteractionResult.Ignored -> class_1269.field_5811;
        };
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 res = super.method_9605(context);
        if (res == null) {
            res = this.method_9564();
        }
        return (class_2680)((class_2680)res.method_11657(Facing, (Comparable)context.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910));
    }

    protected boolean method_9579(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)rot.method_10503((class_2350)state.method_11654(Facing)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)((class_2350)state.method_11654(Facing)).method_10153());
    }

    protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 ret = super.method_9574(level, pos, state, includeData);
        if (!includeData) {
            return ret;
        }
        level.method_35230(pos, PostTile.getBlockEntityType()).ifPresent(tile -> {
            PostData data = new PostData(tile.parts());
            ret.method_57366(class_9326.method_57841().method_57854(PostData.TYPE, (Object)data).method_57852());
        });
        return ret;
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("variant").forGetter(block -> ((PostBlock)block).type.name)).apply((Applicative)builder, variantName -> AllVariants.stream().filter(v -> Objects.equals(v.type.name, variantName)).findAny().orElseThrow().createBlock((TriFunction<class_4970.class_2251, ModelType, Variant, PostBlock>)((TriFunction)PostBlock::new))));
    }

    public static class ModelType {
        private static final Map<String, ModelType> allTypes = new HashMap<String, ModelType>();
        public static final Codec<ModelType> CODEC = Codec.STRING.xmap(allTypes::get, type -> type.name);
        public static final ModelType Acacia = new ModelType("acacia", class_2960.method_60654((String)"acacia_log"), class_2960.method_60654((String)"stripped_acacia_log"), class_2960.method_60654((String)"acacia_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8203), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15525)), r -> class_1856.method_8101((class_1935)class_1802.field_8203));
        public static final ModelType Birch = new ModelType("birch", class_2960.method_60654((String)"birch_log"), class_2960.method_60654((String)"stripped_birch_log"), class_2960.method_60654((String)"birch_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8422), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15554)), r -> class_1856.method_8101((class_1935)class_1802.field_8422));
        public static final ModelType Iron = new ModelType("iron", class_2960.method_60654((String)"iron_block"), class_2960.method_60655((String)"signpost", (String)"iron"), class_2960.method_60655((String)"signpost", (String)"iron_dark"), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15533)), r -> class_1856.method_8101((class_1935)class_1802.field_8620), r -> class_1856.method_8101((class_1935)class_1802.field_8620));
        public static final ModelType Jungle = new ModelType("jungle", class_2960.method_60654((String)"jungle_log"), class_2960.method_60654((String)"stripped_jungle_log"), class_2960.method_60654((String)"jungle_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8867), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15538)), r -> class_1856.method_8101((class_1935)class_1802.field_8867));
        public static final ModelType Oak = new ModelType("oak", class_2960.method_60654((String)"oak_log"), class_2960.method_60654((String)"stripped_oak_log"), class_2960.method_60654((String)"oak_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8788), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15545)), r -> class_1856.method_8101((class_1935)class_1802.field_8788));
        public static final ModelType DarkOak = new ModelType("darkoak", class_2960.method_60654((String)"dark_oak_log"), class_2960.method_60654((String)"stripped_dark_oak_log"), class_2960.method_60654((String)"dark_oak_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8496), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15546)), r -> class_1856.method_8101((class_1935)class_1802.field_8496));
        public static final ModelType Spruce = new ModelType("spruce", class_2960.method_60654((String)"spruce_log"), class_2960.method_60654((String)"stripped_spruce_log"), class_2960.method_60654((String)"spruce_log"), r -> class_1856.method_8101((class_1935)class_1802.field_8111), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15549)), r -> class_1856.method_8101((class_1935)class_1802.field_8111));
        public static final ModelType Mangrove = new ModelType("mangrove", class_2960.method_60654((String)"mangrove_log"), class_2960.method_60654((String)"stripped_mangrove_log"), class_2960.method_60654((String)"mangrove_log"), r -> class_1856.method_8101((class_1935)class_1802.field_37534), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_37403)), r -> class_1856.method_8101((class_1935)class_1802.field_37534));
        public static final ModelType Bamboo = new ModelType("bamboo", class_2960.method_60654((String)"bamboo_block"), class_2960.method_60654((String)"stripped_bamboo_block"), class_2960.method_60654((String)"bamboo_block"), r -> class_1856.method_8101((class_1935)class_1802.field_40228), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_40987)), r -> class_1856.method_8101((class_1935)class_1802.field_40228));
        public static final ModelType Cherry = new ModelType("cherry", class_2960.method_60654((String)"cherry_log"), class_2960.method_60654((String)"stripped_cherry_log"), class_2960.method_60654((String)"cherry_log"), r -> class_1856.method_8101((class_1935)class_1802.field_42709), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_42618)), r -> class_1856.method_8101((class_1935)class_1802.field_42709));
        public static final ModelType Stone = new ModelType("stone", class_2960.method_60654((String)"stone"), class_2960.method_60654((String)"stone"), class_2960.method_60655((String)"signpost", (String)"stone_dark"), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15533)), r -> class_1856.method_8101((class_1935)class_1802.field_20391), r -> class_1856.method_8101((class_1935)class_1802.field_20391));
        public static final ModelType RedMushroom = new ModelType("red_mushroom", class_2960.method_60654((String)"red_mushroom_block"), class_2960.method_60654((String)"mushroom_stem"), class_2960.method_60654((String)"red_mushroom_block"), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15533)), r -> class_1856.method_8101((class_1935)class_1802.field_8682), r -> class_1856.method_8101((class_1935)class_1802.field_17517));
        public static final ModelType BrownMushroom = new ModelType("brown_mushroom", class_2960.method_60654((String)"brown_mushroom_block"), class_2960.method_60654((String)"mushroom_stem"), class_2960.method_60654((String)"brown_mushroom_block"), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15533)), r -> class_1856.method_8101((class_1935)class_1802.field_8506), r -> class_1856.method_8101((class_1935)class_1802.field_17516));
        public static final ModelType Warped = new ModelType("warped", class_2960.method_60654((String)"warped_stem"), class_2960.method_60654((String)"stripped_warped_stem"), class_2960.method_60654((String)"warped_stem"), r -> class_1856.method_8101((class_1935)class_1802.field_22012), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_21958)), r -> class_1856.method_8101((class_1935)class_1802.field_22012));
        public static final ModelType Crimson = new ModelType("crimson", class_2960.method_60654((String)"crimson_stem"), class_2960.method_60654((String)"stripped_crimson_stem"), class_2960.method_60654((String)"crimson_stem"), r -> class_1856.method_8101((class_1935)class_1802.field_22011), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_21957)), r -> class_1856.method_8101((class_1935)class_1802.field_22011));
        private static final class_1856 sandstone = class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_9979, class_2246.field_10361, class_2246.field_10292, class_2246.field_10467});
        public static final ModelType Sandstone = new ModelType("sandstone", class_2960.method_60654((String)"sandstone"), class_2960.method_60654((String)"stripped_jungle_log"), class_2960.method_60654((String)"sandstone_bottom"), r -> class_1856.method_8106((class_6885)r.method_46762(class_7924.field_41197).method_46735(class_3489.field_15533)), r -> sandstone, r -> sandstone);
        public final String name;
        public final Texture postTexture;
        public final Texture mainTexture;
        public final Texture secondaryTexture;
        public final Function<class_7225.class_7874, class_1856> signIngredient;
        public final Function<class_7225.class_7874, class_1856> baseIngredient;
        public final Function<class_7225.class_7874, class_1856> addSignIngredient;
        private static final class_9139<class_9129, Function<class_7225.class_7874, class_1856>> ingredientGetterStreamCodec;
        public static final class_9139<class_9129, ModelType> STREAM_CODEC;

        public static void register(ModelType modelType, String name) {
            if (name.length() < 3 || name.length() > 30) {
                throw new IllegalArgumentException("ModelType name must be between 3 and 30 characters");
            }
            allTypes.put(name, modelType);
        }

        public static void register(ModelType modelType) {
            ModelType.register(modelType, modelType.name);
        }

        public static Optional<ModelType> getByName(String name, boolean logErrorIfNotPresent) {
            if (allTypes.containsKey(name)) {
                return Optional.of(allTypes.get(name));
            }
            if (logErrorIfNotPresent) {
                Signpost.LOGGER.error("Tried to get invalid model type " + name);
            }
            return Optional.empty();
        }

        public static Optional<ModelType> from(class_1792 signItem, class_7225.class_7874 registryAccess) {
            return allTypes.values().stream().filter(t -> t.addSignIngredient.apply(registryAccess).method_8093(new class_1799((class_1935)signItem))).findFirst();
        }

        ModelType(String name, class_2960 postTexture, class_2960 mainTexture, class_2960 secondaryTexture, Function<class_7225.class_7874, class_1856> signIngredient, Function<class_7225.class_7874, class_1856> baseIngredient, Function<class_7225.class_7874, class_1856> addSignIngredient) {
            this(name, ModelType.expand(postTexture), ModelType.expand(mainTexture), ModelType.expand(secondaryTexture), signIngredient, baseIngredient, addSignIngredient);
        }

        public ModelType(String name, Texture postTexture, Texture mainTexture, Texture secondaryTexture, Function<class_7225.class_7874, class_1856> signIngredient, Function<class_7225.class_7874, class_1856> baseIngredient, Function<class_7225.class_7874, class_1856> addSignIngredient) {
            this.name = name;
            this.postTexture = postTexture;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.signIngredient = signIngredient;
            this.baseIngredient = baseIngredient;
            this.addSignIngredient = addSignIngredient;
        }

        private static Texture expand(class_2960 loc) {
            return new Texture(class_2960.method_60655((String)loc.method_12836(), (String)(loc.method_12832().startsWith("block/") ? loc.method_12832() : "block/" + loc.method_12832())));
        }

        static {
            ModelType.register(Acacia);
            ModelType.register(Birch);
            ModelType.register(Iron);
            ModelType.register(Stone);
            ModelType.register(Jungle);
            ModelType.register(Oak);
            ModelType.register(DarkOak);
            ModelType.register(Spruce);
            ModelType.register(Mangrove);
            ModelType.register(Bamboo);
            ModelType.register(Cherry);
            ModelType.register(Warped);
            ModelType.register(Crimson);
            ModelType.register(Sandstone);
            ModelType.register(BrownMushroom);
            ModelType.register(RedMushroom);
            ingredientGetterStreamCodec = class_9139.method_56437((buffer, i) -> class_1856.field_48355.encode(buffer, (Object)((class_1856)i.apply(buffer.method_56349()))), buffer -> {
                class_1856 ingredient = (class_1856)class_1856.field_48355.decode(buffer);
                return r -> ingredient;
            });
            STREAM_CODEC = class_9139.method_64265((class_9139)class_9135.field_48554, mt -> mt.name, Texture.STREAM_CODEC, mt -> mt.postTexture, Texture.STREAM_CODEC, mt -> mt.mainTexture, Texture.STREAM_CODEC, mt -> mt.secondaryTexture, ingredientGetterStreamCodec, mt -> mt.signIngredient, ingredientGetterStreamCodec, mt -> mt.baseIngredient, ingredientGetterStreamCodec, mt -> mt.addSignIngredient, ModelType::new);
        }
    }

    public static class Variant {
        private PostBlock block = null;
        public final String registryName;
        public final class_4970.class_2251 properties;
        public final ModelType type;
        public final RequiredTool tool;

        public Variant(class_4970.class_2251 properties, ModelType type, String registryName, RequiredTool tool) {
            this.registryName = "post_" + registryName;
            this.properties = properties.method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"signpost", (String)this.registryName)));
            this.type = type;
            this.tool = tool;
        }

        public PostBlock createBlock(TriFunction<class_4970.class_2251, ModelType, Variant, PostBlock> factory) {
            assert (this.block == null);
            this.block = (PostBlock)((Object)factory.apply((Object)this.properties, (Object)this.type, (Object)this));
            return this.block;
        }

        public PostBlock getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public static enum RequiredTool {
            Axe,
            Pickaxe;

        }
    }
}

