/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.serialization.MapCodec;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class WaystoneBlock
extends class_2237 {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final String REGISTRY_NAME = "waystone";
    private static WaystoneBlock instance = null;

    public static WaystoneBlock createInstance() {
        assert (instance == null);
        instance = new WaystoneBlock();
        return instance;
    }

    public static WaystoneBlock getInstance() {
        assert (instance != null);
        return instance;
    }

    private WaystoneBlock() {
        this(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"signpost", (String)REGISTRY_NAME))).method_31710(class_3620.field_16023).method_51368(class_2766.field_12653).method_29292().method_9629(1.5f, 6.0f));
    }

    private WaystoneBlock(class_4970.class_2251 properties) {
        super(properties);
        instance = this;
    }

    public static void openGuiIfHasPermission(class_3222 player, WorldLocation worldLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<WaystoneData> data = WaystoneLibrary.getInstance().getHandleByLocation(worldLocation).flatMap(WaystoneLibrary.getInstance()::getData);
        boolean wantsToOpenGui = data.isEmpty() || WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((class_1297)player), ((WaystoneData)data.get()).handle());
        boolean mayOpenGui = data.map(d -> d.hasThePermissionToEdit((class_1657)player)).orElse(true);
        if (wantsToOpenGui && mayOpenGui) {
            PacketHandler.getInstance().sendToPlayer(player, new RequestWaystoneGui.Package(worldLocation, data));
        } else {
            WaystoneBlock.discover(player, (WaystoneData)data.get());
        }
    }

    protected class_1269 method_55765(class_1799 p_316304_, class_2680 p_316362_, class_1937 level, class_2338 pos, class_1657 player, class_1268 p_316595_, class_3965 p_316140_) {
        WaystoneBlock.onRightClick(level, pos, player);
        return class_1269.field_21466;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        WaystoneBlock.onRightClick(level, pos, player);
        return class_1269.field_21466;
    }

    public static void onRightClick(class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.method_8608() && player instanceof class_3222) {
            WaystoneBlock.openGuiIfHasPermission((class_3222)player, WorldLocation.from(pos, world));
        }
    }

    private static void discover(class_3222 player, WaystoneData data) {
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle(player.method_5667()), data.handle())) {
            player.method_64398((class_2561)class_2561.method_43469((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(player, data.name())}));
        }
    }

    public static void discover(PlayerHandle player, WaystoneData data) {
        class_3222 playerEntity;
        assert (Signpost.getServerType().isServer);
        if (WaystoneLibrary.getInstance().addDiscovered(player, data.handle()) && (playerEntity = player.asEntity()) != null) {
            playerEntity.method_64398((class_2561)class_2561.method_43469((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(playerEntity, data.name())}));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042());
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WaystoneTile(pos, state);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public static void registerOwnerAndRequestGui(class_1937 world, class_2338 pos, class_1309 placer, class_1799 currentStack) {
        class_1799 stack = currentStack.method_7972();
        IDelay.forFrames(6, world.method_8608(), () -> TileEntityUtils.delayUntilTileEntityExists((class_1936)world, pos, WaystoneTile.getBlockEntityType(), t -> {
            boolean hasName = WaystoneBlock.registerOwnerAndSeeIfHasName(t, world, pos, placer, stack);
            if (!hasName && placer instanceof class_3222) {
                class_3222 sp = (class_3222)placer;
                PacketHandler.getInstance().sendToPlayer(sp, new RequestWaystoneGui.Package(WorldLocation.from(pos, world), Optional.empty()));
            }
        }, 100, Optional.empty()));
    }

    public static boolean registerOwnerAndSeeIfHasName(class_2586 tileEntity, class_1937 world, class_2338 pos, class_1309 placer, class_1799 stack) {
        if (tileEntity instanceof WithOwner.OfWaystone) {
            WithOwner.OfWaystone waystoneTile = (WithOwner.OfWaystone)tileEntity;
            waystoneTile.setWaystoneOwner(Optional.of(PlayerHandle.from((class_1297)placer)));
        }
        if (placer instanceof class_3222) {
            class_3222 sp = (class_3222)placer;
            WorldLocation worldLocation = WorldLocation.from(pos, world);
            boolean wasRegistered = WaystoneBlock.getCustomName(stack).map(name -> {
                WaystoneLocationData locationData = new WaystoneLocationData(worldLocation, Vector3.fromVec3d(placer.method_73189()));
                WaystoneHandleData handleTag = (WaystoneHandleData)stack.method_58694(WaystoneHandleData.TYPE);
                Optional<WaystoneHandle.Vanilla> handle = handleTag != null ? Optional.of(handleTag.handle()) : Optional.empty();
                return WaystoneLibrary.getInstance().tryAddNew((String)name, locationData, sp, handle);
            }).orElse(false);
            return wasRegistered;
        }
        return false;
    }

    private static Optional<String> getCustomName(class_1799 stack) {
        class_2561 component = stack.method_65130();
        if (component != null) {
            return Optional.of(component.getString());
        }
        return Optional.empty();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (!world.method_8608() && world instanceof class_1937) {
            WaystoneTile.onRemoved((class_3218)world, pos);
        }
    }

    protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 itemStack = super.method_9574(level, pos, state, includeData);
        if (includeData) {
            itemStack = WaystoneBlock.fillClonedItemStack(itemStack, level, pos);
        }
        return itemStack;
    }

    public static class_1799 fillClonedItemStack(class_1799 stack, class_4538 level, class_2338 pos) {
        class_2586 untypedEntity = level.method_8321(pos);
        if (untypedEntity instanceof WaystoneTile) {
            WaystoneTile tile = (WaystoneTile)untypedEntity;
            tile.getHandle().ifPresent(h -> stack.method_57379(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
            tile.getName().ifPresent(n -> stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)n)));
        }
        return stack;
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return WaystoneBlock.method_54094(WaystoneBlock::new);
    }
}

