/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.serialization.MapCodec;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneGeneratorEntity;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.VillageGenUtils;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class WaystoneGeneratorBlock
extends class_2237 {
    public static final class_2754<class_2350> Facing = class_2741.field_12481;
    public static final String REGISTRY_NAME = "waystone_generator";
    private static WaystoneGeneratorBlock instance = null;

    public static WaystoneGeneratorBlock getInstance() {
        if (instance == null) {
            instance = new WaystoneGeneratorBlock();
        }
        return instance;
    }

    private WaystoneGeneratorBlock() {
        super(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"signpost", (String)REGISTRY_NAME))).method_31710(class_3620.field_15996));
    }

    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new WaystoneGeneratorEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{Facing});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(Facing, (Comparable)context.method_8042());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_1269 method_55765(class_1799 item, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.use(state, world, pos);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return this.use(state, level, pos);
    }

    public class_1269 use(class_2680 state, class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 l = (class_3218)level;
            WaystoneGeneratorBlock.generate(state, pos, l, true);
        }
        return class_1269.field_21466;
    }

    public static void generate(class_2680 state, class_2338 pos, class_3218 level, boolean manuallyPlaced) {
        if (!level.method_8320(pos).method_27852((class_2248)instance)) {
            return;
        }
        if (!WaystoneGeneratorBlock.tryPlace(state, pos, level, manuallyPlaced)) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 18);
        }
    }

    private static boolean tryPlace(class_2680 state, class_2338 pos, class_3218 serverLevel, boolean manuallyPlaced) {
        class_2338 villageLocation = VillageGenUtils.getVillageLocationFor(serverLevel, pos, manuallyPlaced ? 0 : 512);
        List<ModelWaystone> allowedWaystones = WaystoneGeneratorBlock.getAllowedWaystones();
        if (allowedWaystones.isEmpty()) {
            Signpost.LOGGER.warn("Tried to generate a waystone, but the list of allowed waystones was empty.");
            return false;
        }
        class_2350 facing = (class_2350)state.method_11654(Facing);
        ModelWaystone waystone = WaystoneGeneratorBlock.getWaystoneType(new Random(serverLevel.method_8412() ^ pos.method_10063()), allowedWaystones);
        Optional<String> optionalName = VillageNamesProvider.requestFor(pos, villageLocation, serverLevel, new Random(serverLevel.method_8412() ^ villageLocation.method_10063()));
        if (optionalName.isEmpty()) {
            Signpost.LOGGER.warn("No name could be generated for waystone at " + String.valueOf(pos) + ".");
            return false;
        }
        String name = optionalName.get();
        boolean isWater = serverLevel.method_22351(pos.method_10084());
        serverLevel.method_8652(pos, (class_2680)((class_2680)waystone.method_9564().method_11657(WaystoneBlock.FACING, (Comparable)facing)).method_11657((class_2769)ModelWaystone.Waterlogged, (Comparable)Boolean.valueOf(isWater)), 18);
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        lib.update(name, WaystoneGeneratorBlock.locationDataFor(pos, serverLevel, facing), null, false);
        lib.data.villageWaystones.register(lib, name, villageLocation, serverLevel, pos);
        return true;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> IConfig.IServer.getInstance().worldGen().allowedVillageWaystones().contains(v.name)).map(ModelWaystone.Variant::getBlock).collect(Collectors.toList());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)rot.method_10503((class_2350)state.method_11654(Facing)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        if (!state.method_28498(Facing)) {
            return state;
        }
        return (class_2680)state.method_11657(Facing, (Comparable)((class_2350)state.method_11654(Facing)).method_10153());
    }

    private static WaystoneLocationData locationDataFor(class_2338 pos, class_3218 world, class_2350 facing) {
        return new WaystoneLocationData(WorldLocation.from(pos, (class_1937)world.method_8410()), WaystoneGeneratorBlock.spawnPosFor(world, pos, facing));
    }

    private static Vector3 spawnPosFor(class_3218 world, class_2338 waystonePos, class_2350 facing) {
        int offset;
        class_2338 spawnBlockPos = waystonePos.method_10079(facing, -2);
        int maxOffset = 10;
        for (offset = 0; WaystoneGeneratorBlock.isFree(world.method_8320(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.method_10074();
        }
        for (offset = 0; !WaystoneGeneratorBlock.isFree(world.method_8320(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.method_10084();
        }
        return Vector3.fromBlockPos(spawnBlockPos).add(0.5f, 0.0f, 0.5f);
    }

    private static boolean isFree(class_2680 state, class_3218 world, class_2338 waystonePos) {
        return state.method_26220((class_1922)world, waystonePos).method_1110();
    }

    private static ModelWaystone getWaystoneType(Random random, List<ModelWaystone> allowedWaystones) {
        return allowedWaystones.get(random.nextInt(allowedWaystones.size()));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return MapCodec.unit((Object)((Object)instance));
    }
}

