/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.platform.Services;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class PostTile
extends class_2586
implements WithOwner.OfSignpost,
WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "post";
    private static class_2591<PostTile> type = null;
    private Map<UUID, BlockPartInstance> parts = new ConcurrentHashMap<UUID, BlockPartInstance>();
    public static final Map<String, BlockPartMetadata<?>> partsMetadata = new ConcurrentHashMap();
    public final PostBlock.ModelType modelType;
    private Optional<PlayerHandle> owner = Optional.empty();
    private final List<Runnable> toDoOnceLevelIsSet = new ArrayList<Runnable>();

    public static class_2591<PostTile> createType() {
        assert (type == null);
        Type type = class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)REGISTRY_NAME);
        PostTile.type = Services.BLOCK_ENTITY_TYPE_FACTORY.create((pos, state) -> new PostTile(PostBlock.ModelType.Oak, (class_2338)pos, (class_2680)state), PostBlock.getAllBlocks(), type);
        return PostTile.type;
    }

    public static class_2591<PostTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public Map<UUID, BlockPartInstance> parts() {
        return this.parts;
    }

    public PostTile(PostBlock.ModelType modelType, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.modelType = modelType;
    }

    public UUID addPart(BlockPartInstance part, class_1799 cost, PlayerHandle player) {
        return this.addPart(UUID.randomUUID(), part, cost, player);
    }

    public UUID addPart(BlockPartInstance part, class_1799 cost, PlayerHandle player, boolean shouldNotify) {
        return this.addPart(UUID.randomUUID(), part, cost, player, shouldNotify);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, class_1799 cost, PlayerHandle player) {
        return this.addPart(identifier, part, cost, player, true);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, class_1799 cost, PlayerHandle player, boolean shouldNotify) {
        this.parts.put(identifier, part);
        Runnable toDo = () -> {
            part.blockPart().attachTo(this);
            if (shouldNotify && this.method_11002() && !this.method_10997().method_8608()) {
                this.sendToTracing(() -> new PartAddedEvent.Packet(new TilePartInfo(this, identifier), part, cost, player));
            }
        };
        if (this.method_11002()) {
            toDo.run();
        } else {
            this.toDoOnceLevelIsSet.add(toDo);
        }
        return identifier;
    }

    public BlockPartInstance removePart(UUID id) {
        BlockPartInstance oldPart = this.parts.remove(id);
        if (oldPart == null) {
            Signpost.LOGGER.error("Failed to remove post block part with id " + String.valueOf(id));
            return oldPart;
        }
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            this.sendToTracing(() -> new PartRemovedEvent.Packet(new TilePartInfo(this, id), false));
        }
        oldPart.blockPart().removeFrom(this);
        this.method_5431();
        return oldPart;
    }

    public void onDestroy() {
        for (BlockPartInstance part : this.parts.values()) {
            part.blockPart().removeFrom(this);
        }
    }

    public Collection<BlockPartInstance> getParts() {
        return this.parts.values();
    }

    public class_265 getBounds() {
        return this.parts.values().stream().map(t -> t.blockPart().getIntersection().getBounds().offset(t.offset()).asMinecraftBB()).map(class_259::method_1078).reduce((b1, b2) -> class_259.method_1072((class_265)b1, (class_265)b2, (class_247)class_247.field_1366)).orElse(class_259.method_1073());
    }

    public Optional<TraceResult> trace(class_1297 player) {
        class_243 head = player.method_73189();
        head = head.method_1031(0.0, (double)player.method_5751(), 0.0);
        if (player.method_18276()) {
            head = head.method_1023(0.0, 0.08, 0.0);
        }
        class_243 look = player.method_5720();
        Ray ray = new Ray(Vector3.fromVec3d(head).subtract(Vector3.fromBlockPos(this.method_11016())), Vector3.fromVec3d(look));
        Optional<class_3545> closestTrace = Optional.empty();
        for (Map.Entry<UUID, BlockPartInstance> t : this.parts.entrySet()) {
            Optional<Float> now = t.getValue().blockPart().intersectWith(ray, t.getValue().offset());
            if (!now.isPresent() || closestTrace.isPresent() && !(((Float)((class_3545)closestTrace.get()).method_15441()).floatValue() > now.get().floatValue())) continue;
            closestTrace = Optional.of(new class_3545((Object)t.getKey(), (Object)now.get()));
        }
        return closestTrace.map(trace -> new TraceResult(this.parts.get(trace.method_15442()), (UUID)trace.method_15442(), ray.atDistance(((Float)trace.method_15441()).floatValue()), ray));
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.writeSelf(output);
    }

    private void writeSelf(class_11372 output) {
        output.method_71460(PostData.CODEC, (Object)new PostData(this.parts));
        output.method_71460(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true), this.owner);
    }

    protected void method_11014(class_11368 input) {
        this.readSelf(input);
    }

    private void readSelf(class_11368 input) {
        this.parts = input.method_71418(PostData.CODEC).map(d -> new ConcurrentHashMap<UUID, BlockPartInstance>(d.parts())).orElseGet(ConcurrentHashMap::new);
        this.owner = input.method_71418(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true)).flatMap(it -> it);
        if (this.parts.isEmpty()) {
            this.parts.put(UUID.randomUUID(), new BlockPartInstance(new PostBlockPart(this.modelType.postTexture), Vector3.ZERO));
        }
        Runnable init = () -> {
            for (BlockPartInstance part : this.parts.values()) {
                part.blockPart().attachTo(this);
            }
        };
        if (this.method_11002()) {
            init.run();
        } else {
            this.toDoOnceLevelIsSet.add(init);
        }
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(PostData.TYPE, (Object)new PostData(this.parts));
        this.getWaystonePart().ifPresent(waystone -> {
            waystone.getHandle().ifPresent(h -> components.method_57840(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
            waystone.getName().ifPresent(n -> components.method_57840(class_9334.field_49631, (Object)class_2561.method_43470((String)n)));
        });
    }

    public void readData(PostData data) {
        this.parts.clear();
        for (Map.Entry<UUID, BlockPartInstance> entry : data.parts().entrySet()) {
            this.addPart(entry.getKey(), entry.getValue(), class_1799.field_8037, PlayerHandle.Invalid);
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (!IConfig.IServer.getInstance().worldGen().debugMode() && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            IDelay.forFrames(1, false, () -> {
                boolean hasChanged = false;
                for (Map.Entry e : this.parts.entrySet().stream().sorted((e1, e2) -> Float.compare(((BlockPartInstance)e2.getValue()).offset().y(), ((BlockPartInstance)e1.getValue()).offset().y())).toList()) {
                    SignBlockPart sign;
                    BlockPart patt0$temp = ((BlockPartInstance)e.getValue()).blockPart();
                    if (!(patt0$temp instanceof SignBlockPart) || !(sign = (SignBlockPart)patt0$temp).isMarkedForGeneration() || !VillageSignpost.populate(this, sign, (UUID)e.getKey(), ((BlockPartInstance)e.getValue()).offset().y(), serverLevel)) continue;
                    hasChanged = true;
                }
                if (hasChanged) {
                    level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
                }
            });
        }
        this.toDoOnceLevelIsSet.forEach(Runnable::run);
        this.toDoOnceLevelIsSet.clear();
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_11362 output = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)provider);
        this.writeSelf((class_11372)output);
        return output.method_71475();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void notifyMutation(UUID part, BlockPartInstance data, String partMetaIdentifier) {
        this.sendToTracing(() -> new PartMutatedEvent.Packet(new TilePartInfo(this, part), data.blockPart(), partMetaIdentifier, Optional.empty()));
        this.method_5431();
    }

    public <T> void sendToTracing(Supplier<T> t) {
        PacketHandler.getInstance().sendToTracing(this, t);
    }

    public void setSignpostOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Optional<PlayerHandle> getSignpostOwner() {
        return this.owner;
    }

    public Optional<WaystoneBlockPart> getWaystonePart() {
        return this.getParts().stream().filter(p -> p.blockPart() instanceof WaystoneBlockPart).findFirst().map(p -> (WaystoneBlockPart)p.blockPart());
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.getWaystonePart().flatMap(WaystoneBlockPart::getWaystoneOwner);
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.getWaystonePart().ifPresent(part -> part.setWaystoneOwner(owner));
    }

    public static boolean isAngleTool(class_1792 item) {
        return item instanceof Wrench;
    }

    public Optional<BlockPartInstance> getPart(UUID id) {
        return this.parts.containsKey(id) ? Optional.of(this.parts.get(id)) : Optional.empty();
    }

    static {
        partsMetadata.put(PostBlockPart.METADATA.identifier(), PostBlockPart.METADATA);
        partsMetadata.put(SmallWideSignBlockPart.METADATA.identifier(), SmallWideSignBlockPart.METADATA);
        partsMetadata.put(SmallShortSignBlockPart.METADATA.identifier(), SmallShortSignBlockPart.METADATA);
        partsMetadata.put(LargeSignBlockPart.METADATA.identifier(), LargeSignBlockPart.METADATA);
        partsMetadata.put(WaystoneBlockPart.METADATA.identifier(), WaystoneBlockPart.METADATA);
    }

    public static class PartMutatedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(@NotNull Packet message, PacketHandler.Context context) {
            boolean isServer = context instanceof PacketHandler.Context.Server;
            TileEntityUtils.findWorld(message.info.dimensionKey, !isServer).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(WorldLocation.from(message.info.pos, level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.parts.get(message.info.identifier);
                Vector3 offset = message.offset.orElse(oldPart != null ? oldPart.offset() : Vector3.ZERO);
                if (oldPart != null) {
                    oldPart.blockPart().removeFrom((PostTile)tile);
                } else {
                    Signpost.LOGGER.error("Tried to mutate a post part that wasn't present: " + String.valueOf(message.info.identifier));
                }
                tile.parts.put(message.info.identifier, new BlockPartInstance(message.blockPart, offset));
                message.blockPart().attachTo((PostTile)tile);
                tile.method_5431();
                if (isServer) {
                    tile.sendToTracing(() -> message);
                }
            }, 100, !isServer, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartMutatedEvent, tile was not present"))));
        }

        public record Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier, Optional<Vector3> offset) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56905(TilePartInfo.STREAM_CODEC, Packet::info, BlockPart.STREAM_CODEC, Packet::blockPart, (class_9139)class_9135.field_48554, Packet::partMetaIdentifier, (class_9139)class_9135.method_56382(Vector3.STREAM_CODEC), Packet::offset, Packet::new);

            public Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier) {
                this(info, blockPart, partMetaIdentifier, Optional.empty());
            }

            public Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier, Vector3 offset) {
                this(info, blockPart, partMetaIdentifier, Optional.of(offset));
            }
        }
    }

    public static class TilePartInfo {
        public final class_2960 dimensionKey;
        public final class_2338 pos;
        public final UUID identifier;
        public static final Codec<TilePartInfo> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("Dimension").forGetter(t -> t.dimensionKey), (App)BlockPosSerializer.CODEC.fieldOf("Pos").forGetter(t -> t.pos), (App)class_4844.field_25122.fieldOf("Id").forGetter(t -> t.identifier)).apply((Applicative)i, TilePartInfo::new));
        public static final class_9139<ByteBuf, TilePartInfo> STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, t -> t.dimensionKey, (class_9139)class_2338.field_48404, t -> t.pos, (class_9139)class_4844.field_48453, t -> t.identifier, TilePartInfo::new);

        public TilePartInfo(class_2586 tile, UUID identifier) {
            this.dimensionKey = tile.method_10997().method_27983().method_29177();
            this.pos = tile.method_11016();
            this.identifier = identifier;
        }

        public TilePartInfo(class_2960 dimensionKey, class_2338 pos, UUID identifier) {
            this.dimensionKey = dimensionKey;
            this.pos = pos;
            this.identifier = identifier;
        }
    }

    public static class TraceResult {
        public final BlockPartInstance part;
        public final UUID id;
        public final Vector3 hitPos;
        public final Ray ray;

        public TraceResult(BlockPartInstance part, UUID id, Vector3 hitPos, Ray ray) {
            this.part = part;
            this.id = id;
            this.hitPos = hitPos;
            this.ray = ray;
        }
    }

    public static class PartRemovedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            boolean isClient = context instanceof PacketHandler.Context.Client;
            TileEntityUtils.findWorld(message.info.dimensionKey, isClient).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(WorldLocation.from(message.info.pos, level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.removePart(message.info.identifier);
                if (oldPart != null && context instanceof PacketHandler.Context.Server) {
                    class_3222 sender;
                    PacketHandler.Context.Server $b$0 = (PacketHandler.Context.Server)context;
                    try {
                        class_3222 patt1$temp;
                        sender = patt1$temp = $b$0.sender();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (!sender.method_68878() && message.shouldDropItem) {
                        for (class_1799 item : oldPart.blockPart().getDrops()) {
                            class_1937 patt2$temp;
                            if (sender.method_31548().method_7394(item) || !((patt2$temp = tile.method_10997()) instanceof class_3218)) continue;
                            class_3218 serverWorld = (class_3218)patt2$temp;
                            class_2338 pos = message.info.pos;
                            class_1542 itementity = new class_1542((class_1937)serverWorld, (double)pos.method_10263() + (double)serverWorld.method_8409().method_43057() * 0.5 + 0.25, (double)pos.method_10264() + (double)serverWorld.method_8409().method_43057() * 0.5 + 0.25, (double)pos.method_10260() + (double)serverWorld.method_8409().method_43057() * 0.5 + 0.25, item);
                            itementity.method_6988();
                            serverWorld.method_8649((class_1297)itementity);
                        }
                    }
                }
            }, 100, isClient, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartRemovedEvent, tile was not present"))));
        }

        public record Packet(TilePartInfo info, boolean shouldDropItem) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56435(TilePartInfo.STREAM_CODEC, Packet::info, (class_9139)class_9135.field_48547, Packet::shouldDropItem, Packet::new);
        }
    }

    public static class PartAddedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            boolean isClientSide = context instanceof PacketHandler.Context.Client;
            TileEntityUtils.findTileEntity(message.info.dimensionKey, isClientSide, message.info.pos, PostTile.getBlockEntityType()).ifPresent(tile -> {
                tile.addPart(message.info.identifier, message.part, message.cost, message.player);
                if (message.cost.method_7947() > 0 && (!isClientSide || SideUtils.getClientPlayer().map(player -> player.method_5667().equals(message.player.id())).orElse(false).booleanValue())) {
                    class_3222 class_32222;
                    if (context instanceof PacketHandler.Context.Server) {
                        PacketHandler.Context.Server $b$0 = (PacketHandler.Context.Server)context;
                        try {
                            class_3222 patt1$temp;
                            class_3222 sender;
                            class_32222 = sender = (patt1$temp = $b$0.sender());
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    } else {
                        class_32222 = null;
                    }
                    SideUtils.makePlayerPayIfEditor(isClientSide, class_32222, message.player, message.cost);
                }
                tile.method_5431();
            });
        }

        public record Packet(TilePartInfo info, BlockPartInstance part, class_1799 cost, PlayerHandle player) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56905(TilePartInfo.STREAM_CODEC, Packet::info, BlockPartInstance.STREAM_CODEC, Packet::part, (class_9139)class_1799.field_49268, Packet::cost, PlayerHandle.STREAM_CODEC, Packet::player, Packet::new);
        }
    }

    public static class UpdateAllPartsEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public class_9139<class_9129, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            if (context instanceof PacketHandler.Context.Client) {
                TileEntityUtils.delayUntilTileEntityExistsAt(message.location, PostTile.getBlockEntityType(), tile -> tile.method_58690(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)context.getHolderLookupProvider(), (class_2487)message.tag)), 20, true, Optional.empty());
            }
        }

        public record Packet(class_2487 tag, WorldLocation location) {
            public static final class_9139<class_9129, Packet> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_57998(class_2505::method_53898), Packet::tag, WorldLocation.STREAM_CODEC, Packet::location, Packet::new);

            public static Packet from(class_2487 tag, WorldLocation location) {
                return new Packet(tag, location.withoutExplicitLevel());
            }
        }
    }
}

