/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Codec;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.platform.Services;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WorldLocation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1208;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class WaystoneTile
extends class_2586
implements WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "waystone";
    private static class_2591<WaystoneTile> type = null;
    private Optional<PlayerHandle> owner = Optional.empty();
    private Optional<WaystoneHandle.Vanilla> handle = Optional.empty();
    private Optional<String> name = Optional.empty();
    private final EventDispatcher.Listener<WaystoneUpdatedEvent> updateListener = event -> {
        if (WorldLocation.from(this).map(loc -> loc.equals(event.location.block())).orElse(false).booleanValue()) {
            this.name = Optional.of(event.name);
            this.handle = Optional.of(event.handle);
        }
        return false;
    };

    public static class_2591<WaystoneTile> createType() {
        assert (type == null);
        Type type = class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)REGISTRY_NAME);
        ArrayList<class_2237> blocks = new ArrayList<class_2237>();
        blocks.add(WaystoneBlock.getInstance());
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            blocks.add(variant.getBlock());
        }
        WaystoneTile.type = Services.BLOCK_ENTITY_TYPE_FACTORY.create(WaystoneTile::new, (class_2248[])blocks.toArray(class_2248[]::new), type);
        return WaystoneTile.type;
    }

    public static class_2591<WaystoneTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public Optional<WaystoneHandle.Vanilla> getHandle() {
        return this.handle;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public WaystoneTile(class_2338 pos, class_2680 state) {
        super(WaystoneTile.getBlockEntityType(), pos, state);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        IDelay.forFrames(10, level.method_8608(), () -> {
            WaystoneLibrary.getInstance().requestWaystoneAt(WorldLocation.from(this.method_11016(), level), data -> {
                this.handle = data.map(WaystoneData::handle);
                this.name = data.map(WaystoneData::name);
            }, level.method_8608());
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.updateListener);
        });
    }

    public static void onRemoved(class_3218 world, class_2338 pos) {
        WaystoneLibrary.getInstance().removeAt(WorldLocation.from(pos, (class_1937)world), PlayerHandle.Invalid);
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public void method_11007(class_11372 output) {
        output.method_71460(PlayerHandle.DIRECT_CODEC.optionalFieldOf("Owner"), this.owner);
    }

    protected void method_11014(class_11368 input) {
        this.owner = input.method_71418(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true)).flatMap(it -> it);
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        this.handle.ifPresent(h -> components.method_57840(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
        this.name.ifPresent(n -> components.method_57840(class_9334.field_49631, (Object)class_2561.method_43470((String)n)));
    }
}

