/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.gui.utils.Colors;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class WaystoneArgument
implements ArgumentType<String> {
    private static final Pattern nonLiteralPattern = Pattern.compile("[^a-z0-9]", 2);

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (WaystoneLibrary.hasInstance() && WaystoneLibrary.getInstance().getAllWaystoneNames(false).map(n -> n.contains(name)).orElse(true).booleanValue()) {
            return name;
        }
        throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(name, Colors.highlight)})).create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!WaystoneLibrary.hasInstance()) {
            return class_2172.method_9265(new HashSet(), (SuggestionsBuilder)builder);
        }
        CompletableFuture<Suggestions> ret = new CompletableFuture<Suggestions>();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> class_2172.method_9265((Iterable)names.values().stream().map(s -> nonLiteralPattern.matcher((CharSequence)s).find() ? "\"" + s + "\"" : s).collect(Collectors.toSet()), (SuggestionsBuilder)builder).thenAccept(ret::complete), Optional.empty(), Signpost.getServerType().isClient);
        return ret;
    }

    public static class Info
    implements class_2314<WaystoneArgument, Template> {
        public void serializeToNetwork(Template arg, class_2540 buffer) {
        }

        public Template deserializeFromNetwork(class_2540 buffer) {
            return new Template();
        }

        public void serializeToJson(Template arg, JsonObject buffer) {
        }

        public Template unpack(WaystoneArgument argument) {
            return new Template();
        }

        public final class Template
        implements class_2314.class_7217<WaystoneArgument> {
            public WaystoneArgument instantiate(class_7157 context) {
                return new WaystoneArgument();
            }

            public class_2314<WaystoneArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

