/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.Teleport;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageView;
import gollorum.signpost.minecraft.gui.widgets.SignpostImageButton;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ConfirmTeleportGui
extends class_437 {
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private static final int costCenterSpace = 10;
    private final Either<String, Teleport.RequestGui.Package.Info> data;
    private final Optional<SignInfo> signInfo;

    public ConfirmTeleportGui(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        super((class_2561)class_2561.method_43471((String)"gui.signpost.confirm_teleport_gui_title"));
        this.data = data;
        this.signInfo = signInfo;
    }

    public static void display(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        class_310.method_1551().method_1507((class_437)new ConfirmTeleportGui(data, signInfo));
    }

    protected void method_25426() {
        super.method_25426();
        AtomicInteger editButtonTop = new AtomicInteger();
        this.data.consume(langKey -> {
            this.method_37060(new TextDisplay((class_2561)class_2561.method_43471((String)langKey), new Point(this.field_22789 / 2, this.field_22790 / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.field_22793));
            editButtonTop.set(this.field_22790 / 2 + 20);
        }, d -> {
            boolean isTooFarAway;
            boolean bl = isTooFarAway = d.maxDistance() > 0 && d.distance() > d.maxDistance();
            if (d.cannotTeleportBecause().isEmpty() && !isTooFarAway) {
                this.method_37060(new TextDisplay((class_2561)class_2561.method_43469((String)"gui.signpost.confirm_teleport", (Object[])new Object[]{Colors.wrap(d.waystoneName(), Colors.highlight)}), new Point(this.field_22789 / 2, this.field_22790 / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.field_22793));
                if (!d.cost().method_7960()) {
                    this.method_37060(new TextDisplay((class_2561)class_2561.method_43471((String)"gui.signpost.cost"), new Point(this.field_22789 / 2 - 5, this.field_22790 / 2), Rect.XAlignment.Right, Rect.YAlignment.Center, this.field_22793));
                    Rect itemRect = new Rect(new Point(this.field_22789 / 2 + 5, this.field_22790 / 2), TextureResource.itemBackground.size, Rect.XAlignment.Left, Rect.YAlignment.Center);
                    this.method_37060(new ImageView(TextureResource.itemBackground, itemRect));
                    this.method_37060((class_4068)new GuiItemRenderer(new Rect(itemRect.center(), 16, 16, Rect.XAlignment.Center, Rect.YAlignment.Center), d.cost()));
                }
                Rect confirmRect = new Rect(new Point(this.field_22789 / 2 + 20, this.field_22790 / 2 + 20), buttonsSize, Rect.XAlignment.Left, Rect.YAlignment.Top);
                Rect cancelRect = new Rect(new Point(this.field_22789 / 2 - 20, this.field_22790 / 2 + 20), buttonsSize, Rect.XAlignment.Right, Rect.YAlignment.Top);
                this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.proceed"), b -> this.confirm()).method_46434(confirmRect.point.x, confirmRect.point.y, confirmRect.width, confirmRect.height).method_46431());
                this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.cancel()).method_46434(cancelRect.point.x, cancelRect.point.y, cancelRect.width, cancelRect.height).method_46431());
                editButtonTop.set(cancelRect.max().y + 20);
            } else {
                d.cannotTeleportBecause().ifPresent(reason -> this.method_37060(new TextDisplay((class_2561)reason, new Point(this.field_22789 / 2, this.field_22790 / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.field_22793)));
                if (isTooFarAway) {
                    this.method_37060(new TextDisplay((class_2561)class_2561.method_43469((String)"signpost.too_far_away", (Object[])new Object[]{Colors.wrap(Integer.toString(d.distance()), Colors.highlight), Colors.wrap(Integer.toString(d.maxDistance()), Colors.highlight)}), new Point(this.field_22789 / 2, this.field_22790 / 2 - (d.cannotTeleportBecause().isEmpty() ? 20 : 40)), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.field_22793));
                }
                editButtonTop.set(this.field_22790 / 2 + 20);
            }
        });
        this.signInfo.ifPresent(info -> {
            Rect editRect = new Rect(new Point(this.field_22789 / 2, editButtonTop.get()), TextureResource.edit.size, Rect.XAlignment.Center, Rect.YAlignment.Top);
            if (info.sign.hasThePermissionToEdit(info.tile, (class_1657)this.field_22787.field_1724)) {
                this.method_37063((class_364)new SignpostImageButton(TextureResource.edit, editRect, b -> SignGui.display(info.tile, info.sign, info.offset, info.tilePartInfo)));
            }
        });
    }

    private void confirm() {
        this.field_22787.method_1507(null);
        this.data.consume(langKey -> this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)langKey), true), data -> PacketHandler.getInstance().sendToServer(new Teleport.Request.Package(data.waystoneName(), data.handle())));
    }

    private void cancel() {
        this.field_22787.method_1507(null);
    }

    public static class SignInfo {
        public final PostTile tile;
        public final SignBlockPart sign;
        public final PostTile.TilePartInfo tilePartInfo;
        public final Vector3 offset;

        public SignInfo(PostTile tile, SignBlockPart sign, PostTile.TilePartInfo tilePartInfo, Vector3 offset) {
            this.tile = tile;
            this.sign = sign;
            this.tilePartInfo = tilePartInfo;
            this.offset = offset;
        }
    }
}

