/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.Streams;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.gui.utils.IFluidTextureProvider;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.GuiBlockPartRenderer;
import gollorum.signpost.minecraft.gui.widgets.ItemButton;
import gollorum.signpost.minecraft.gui.widgets.SpriteSelectionButton;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.minecraft.utils.tints.BlockColorTint;
import gollorum.signpost.minecraft.utils.tints.FluidTint;
import gollorum.signpost.mixin.BucketAccessor;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4730;
import net.minecraft.class_5819;

public abstract class PaintBlockPartGui<T extends BlockPart<T>>
extends class_437 {
    private final PostTile tile;
    private final int maxBlocksPerRow = 9;
    private List<SpriteSelectionButton> textureButtons = new ArrayList<SpriteSelectionButton>();
    protected final T part;
    protected final T displayPart;
    protected Tuple<Either<class_1058, class_4730>, Optional<Tint>> oldSprite;
    private final UUID identifier;
    private static final class_2350[] faces = new class_2350[]{null, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033};

    public PaintBlockPartGui(PostTile tile, T part, T displayPart, UUID identifier, Texture oldTexture) {
        super((class_2561)class_2561.method_43470((String)"Paint Post"));
        this.tile = tile;
        this.part = part;
        this.displayPart = displayPart;
        this.oldSprite = Tuple.of(Either.right(oldTexture.toMaterial()), oldTexture.tint());
        this.identifier = identifier;
    }

    protected Either<class_1058, class_4730> spriteFrom(class_2960 loc) {
        return Either.right(new class_4730(TextureResource.blockAtlas, loc));
    }

    protected void method_25426() {
        super.method_25426();
        List<Tuple> blocksToRender = Streams.stream((Iterable)this.field_22787.field_1724.method_31548()).filter(i -> !i.method_7960() && (i.method_7909() instanceof class_1747 || i.method_7909() instanceof class_1755)).map(i -> {
            class_1799 ret = i.method_7972();
            ret.method_7939(1);
            return ret;
        }).distinct().map(is -> Tuple.of(this.allSpritesFor((class_1799)is), is)).filter(p -> !((List)p._1()).isEmpty()).toList();
        int rows = (blocksToRender.size() + 8) / 9;
        for (int y = 0; y < rows; ++y) {
            int rowWidth = y == rows - 1 ? (blocksToRender.size() - 1) % 9 + 1 : 9;
            int top = this.field_22790 * 3 / 4 + y * 20;
            int left = this.field_22789 / 2 - rowWidth * 20 / 2;
            for (int x = 0; x < rowWidth; ++x) {
                Tuple tuple = blocksToRender.get(x + y * 9);
                this.method_37063((class_364)new ItemButton(left + x * 20, top, Rect.XAlignment.Left, Rect.YAlignment.Bottom, (class_1799)tuple._2(), b -> this.setupTextureButtonsFor((List)tuple._1()), class_310.method_1551().method_1480(), this.field_22793));
            }
        }
        this.method_37063((class_364)new GuiBlockPartRenderer(this.tile.getParts().stream().map(p -> p.blockPart() == this.part ? new BlockPartInstance((BlockPart)this.displayPart, p.offset()) : p).collect(Collectors.toList()), new Point(this.field_22789 / 2, this.field_22790 / 4), Angle.fromDegrees(this.field_22787.field_1724.method_36454() + 180.0f), Angle.fromDegrees(this.field_22787.field_1724.method_36455()), 64.0f, this.field_22793));
    }

    private List<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> allSpritesFor(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            return this.allSpritesFor((class_1747)item, stack);
        }
        if (item instanceof class_1755) {
            return this.allSpritesFor((class_1755)item);
        }
        throw new RuntimeException("Item type of " + String.valueOf(item.getClass()) + " not supported");
    }

    private List<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> allSpritesFor(class_1747 item, class_1799 stack) {
        class_2248 block = item.method_7711();
        if (!(block instanceof PostBlock)) {
            return this.allSpritesFor(block.method_9564());
        }
        PostData data = (PostData)stack.method_58694(PostData.TYPE);
        if (data != null) {
            ArrayList<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> ret = new ArrayList<Tuple<Either<class_1058, class_4730>, Optional<Tint>>>(data.parts().size());
            for (Map.Entry<UUID, BlockPartInstance> entry : data.parts().entrySet()) {
                BlockPartInstance part = entry.getValue();
                Collection<Texture> partTextures = part.blockPart().getAllTextures();
                for (Texture tex : partTextures) {
                    ret.add(Tuple.of(Either.right(tex.toMaterial()), tex.tint()));
                }
            }
            return ret;
        }
        return this.allSpritesFor(block.method_9564());
    }

    private List<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> allSpritesFor(class_1755 item) {
        FluidTint fluidTint = new FluidTint(((BucketAccessor)item).getContent());
        ArrayList<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> ret = new ArrayList<Tuple<Either<class_1058, class_4730>, Optional<Tint>>>(3);
        class_2960 loc = null;
        IFluidTextureProvider fluidTextureProvider = IFluidTextureProvider.getInstance();
        loc = fluidTextureProvider.getFlowingTexture(fluidTint.fluid());
        if (loc != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        if ((loc = fluidTextureProvider.getOverlayTexture(fluidTint.fluid())) != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        if ((loc = fluidTextureProvider.getStillTexture(fluidTint.fluid())) != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        return ret;
    }

    private List<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> allSpritesFor(class_2680 state) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        class_5819 random = class_5819.method_43049((long)((Object)((Object)this)).hashCode());
        return Arrays.stream(faces).flatMap(side -> model.method_68512(random).stream().flatMap(part -> part.method_68509(side).stream())).map(bakedQuad -> Tuple.of(bakedQuad.comp_3724(), bakedQuad.comp_3722())).distinct().map(loc -> Tuple.of(Either.left((class_1058)loc._1()), (Integer)loc._2() >= 0 ? Optional.of(new BlockColorTint(state.method_26204(), (Integer)loc._2())) : Optional.empty())).collect(Collectors.toList());
    }

    private void setupTextureButtonsFor(List<Tuple<Either<class_1058, class_4730>, Optional<Tint>>> sprites) {
        this.clearSelection();
        sprites = Streams.concat((Stream[])new Stream[]{Stream.of(this.oldSprite), sprites.stream()}).distinct().collect(Collectors.toList());
        int spriteButtonSize = 30;
        int centerY = this.field_22790 / 2 + 10;
        int left = this.field_22789 / 2 - sprites.size() * spriteButtonSize / 2;
        for (int x = 0; x < sprites.size(); ++x) {
            Tuple<Either<Object, Object>, Optional<Tint>> sprite = sprites.get(x);
            SpriteSelectionButton newButton = new SpriteSelectionButton(new Rect(new Point(left + x * spriteButtonSize, centerY), spriteButtonSize, spriteButtonSize, Rect.XAlignment.Left, Rect.YAlignment.Center), sprite._1(), sprite._2().map(t -> t.getColorAt((class_1920)this.field_22787.field_1687, this.field_22787.field_1724.method_24515())).orElse(-1), imgButton -> this.setTexture(this.displayPart, new Texture(((Either)sprite._1()).match(tas -> tas.method_45851().method_45816(), class_4730::method_24147), ((Either)sprite._1()).match(class_1058::method_45852, class_4730::method_24144), (Optional<Tint>)((Optional)sprite._2()))));
            this.method_37063((class_364)newButton);
            this.textureButtons.add(newButton);
        }
    }

    protected void clearSelection() {
        for (SpriteSelectionButton button : this.textureButtons) {
            this.method_37066((class_364)button);
        }
    }

    protected abstract void setTexture(T var1, Texture var2);

    public void method_25419() {
        super.method_25419();
        PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(new PostTile.TilePartInfo(this.tile, this.identifier), (BlockPart)this.displayPart, this.part.getMeta().identifier()));
    }
}

