/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.FlippableAtPivot;
import gollorum.signpost.minecraft.gui.utils.IColorableButton;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.utils.WaystoneEntry;
import gollorum.signpost.minecraft.gui.widgets.AngleInputBox;
import gollorum.signpost.minecraft.gui.widgets.ColorInputBox;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.GuiModelRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.minecraft.gui.widgets.ModelButton;
import gollorum.signpost.minecraft.gui.widgets.SignpostImageButton;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.minecraft.models.LargeSignModel;
import gollorum.signpost.minecraft.models.PostModel;
import gollorum.signpost.minecraft.models.ShortSignModel;
import gollorum.signpost.minecraft.models.WideSignModel;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.mixin.ScreenAccessor;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_347;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class SignGui
extends class_437 {
    private static final TextureSize typeSelectionButtonsTextureSize = TextureResource.signTypeSelection.size;
    private static final TextureResource waystoneNameTexture = TextureResource.waystoneNameField;
    private static final TextureSize typeSelectionButtonsSize = new TextureSize(SignGui.typeSelectionButtonsTextureSize.width * 2, SignGui.typeSelectionButtonsTextureSize.height * 2);
    private static final int typeSelectionButtonsSpace = (int)((float)SignGui.typeSelectionButtonsSize.width * 0.3f);
    private static final int typeSelectionButtonsY = 15;
    private static final float typeSelectionButtonsScale = 0.66f;
    private static final float overlayButtonsScale = 0.5f;
    private static final int centralAreaHeight = 110;
    private static final int centerGap = 15;
    private static final float waystoneBoxScale = 2.5f;
    final int inputSignsScale = 5;
    private ImageInputBox waystoneInputBox;
    private DropDownSelection<WaystoneEntry> waystoneDropdown;
    private class_347 lockButton;
    private DropDownSelection<AngleSelectionEntry> angleDropDown;
    private TextDisplay rotationLabel;
    private AngleInputBox rotationInputField;
    private final Optional<class_1799> itemToDropOnBreak;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> {
        WaystoneEntry newEntry = new WaystoneEntry(event.name, event.name, event.handle, event.location.block().blockPos());
        switch (event.getType()) {
            case Added: {
                this.waystoneDropdown.addEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Removed: {
                this.waystoneDropdown.removeEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Renamed: {
                String oldName = ((WaystoneRenamedEvent)event).oldName;
                WaystoneEntry oldEntry = new WaystoneEntry(oldName, oldName, event.handle, event.location.block().blockPos());
                this.waystoneDropdown.removeEntry(oldEntry);
                this.waystoneDropdown.addEntry(newEntry);
            }
        }
    };
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private SignType selectedType = null;
    private final PostTile tile;
    private final class_1799 itemStack;
    private final PostBlock.ModelType modelType;
    private final Vector3 localHitPos;
    private final Optional<SignBlockPart> oldSign;
    private final Optional<PostTile.TilePartInfo> oldTilePartInfo;
    private final List<Flippable> widgetsToFlip = new ArrayList<Flippable>();
    private InputBox wideSignInputBox;
    private InputBox shortSignInputBox;
    private List<InputBox> largeSignInputBoxes;
    private List<InputBox> allSignInputBoxes;
    private GuiModelRenderer wideSignRenderer;
    private GuiModelRenderer shortSignRenderer;
    private GuiModelRenderer largeSignRenderer;
    private GuiModelRenderer currentSignRenderer;
    private InputBox currentSignInputBox;
    private ColorInputBox colorInputBox;
    private Optional<WaystoneEntry> lastWaystone = Optional.empty();
    private AngleSelectionEntry waystoneRotationEntry;
    private Optional<Overlay> selectedOverlay;
    private final List<ModelButton> overlaySelectionButtons = new ArrayList<ModelButton>();
    private boolean hasBeenInitialized = false;
    private TextDisplay noWaystonesInfo;
    private final List<class_339> selectionDependentWidgets = Lists.newArrayList();
    private GuiModelRenderer currentOverlay;
    private boolean isClosed = false;

    public static void display(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, Optional<class_1799> itemToDropOnBreak) {
        class_310.method_1551().method_1507((class_437)new SignGui(tile, modelType, localHitPos, itemToDropOnBreak));
    }

    public static void display(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        if (oldSign.hasThePermissionToEdit(tile, (class_1657)class_310.method_1551().field_1724)) {
            class_310.method_1551().method_1507((class_437)new SignGui(tile, oldSign, oldOffset, oldTilePartInfo));
        }
    }

    public SignGui(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, Optional<class_1799> itemToDropOnBreak) {
        super((class_2561)class_2561.method_43471((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = modelType;
        this.localHitPos = localHitPos;
        this.itemToDropOnBreak = itemToDropOnBreak;
        this.oldSign = Optional.empty();
        this.oldTilePartInfo = Optional.empty();
        this.itemStack = new class_1799((class_1935)tile.method_11010().method_26204().method_8389());
    }

    public SignGui(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        super((class_2561)class_2561.method_43471((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = oldSign.getModelType();
        this.localHitPos = oldOffset;
        this.itemToDropOnBreak = oldSign.getItemToDropOnBreak();
        this.oldSign = Optional.of(oldSign);
        this.oldTilePartInfo = Optional.of(oldTilePartInfo);
        this.itemStack = new class_1799((class_1935)tile.method_11010().method_26204().method_8389());
    }

    protected void method_25426() {
        class_4185 doneButton;
        Angle currentAngle;
        int currentColor;
        boolean isFlipped;
        NameProvider[] currentText;
        String currentWaystone;
        SignType currentType;
        this.isClosed = false;
        if (this.hasBeenInitialized) {
            NameProvider[] nameProviderArray;
            currentType = this.selectedType;
            currentWaystone = this.waystoneInputBox.method_1882();
            switch (currentType.ordinal()) {
                case 1: {
                    NameProvider[] nameProviderArray2 = new NameProvider[1];
                    nameProviderArray = nameProviderArray2;
                    nameProviderArray2[0] = this.asNameProvider(this.shortSignInputBox.method_1882());
                    break;
                }
                case 2: {
                    nameProviderArray = (NameProvider[])this.largeSignInputBoxes.stream().map(class_342::method_1882).map(this::asNameProvider).toArray(NameProvider[]::new);
                    break;
                }
                default: {
                    NameProvider[] nameProviderArray3 = new NameProvider[1];
                    nameProviderArray = nameProviderArray3;
                    nameProviderArray3[0] = this.asNameProvider(this.wideSignInputBox.method_1882());
                }
            }
            currentText = nameProviderArray;
            isFlipped = this.widgetsToFlip.get(0).isFlipped();
            this.widgetsToFlip.clear();
            currentColor = this.colorInputBox.getCurrentColor();
            currentAngle = this.rotationInputField.getCurrentAngle();
        } else {
            currentWaystone = "";
            if (this.oldSign.isPresent()) {
                if (this.oldSign.get() instanceof LargeSignBlockPart) {
                    currentType = SignType.Large;
                    LargeSignBlockPart sign = (LargeSignBlockPart)this.oldSign.get();
                    currentText = sign.getText();
                } else if (this.oldSign.get() instanceof SmallShortSignBlockPart) {
                    currentType = SignType.Short;
                    currentText = new NameProvider[]{((SmallShortSignBlockPart)this.oldSign.get()).getText()};
                } else {
                    currentType = SignType.Wide;
                    currentText = new NameProvider[]{((SmallWideSignBlockPart)this.oldSign.get()).getText()};
                }
                isFlipped = this.oldSign.get().isFlipped();
                currentColor = this.oldSign.get().getColor();
                currentAngle = this.oldSign.get().getAngle().get();
                this.selectedOverlay = this.oldSign.get().getOverlay();
            } else {
                currentType = SignType.Wide;
                currentText = new NameProvider[]{new NameProvider.Literal("")};
                isFlipped = true;
                currentColor = 0;
                currentAngle = Angle.ZERO;
                this.selectedOverlay = Optional.empty();
            }
        }
        super.method_25426();
        this.selectedType = null;
        int signTypeSelectionTopY = 15;
        int centerOffset = (SignGui.typeSelectionButtonsSize.width + typeSelectionButtonsSpace) / 2;
        Texture postTexture = this.tile.getParts().stream().filter(p -> p.blockPart() instanceof PostBlockPart).map(p -> ((PostBlockPart)p.blockPart()).getTexture()).findFirst().orElse(this.tile.modelType.postTexture);
        Texture mainTexture = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        Texture secondaryTexture = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        FlippableModel postModel = FlippableModel.fromSymmetric(new TexturedModel[]{new TexturedModel(PostModel.MODEL, postTexture.toMaterial(), this.colorFrom(postTexture.tint()))});
        FlippableModel wideModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(WideSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(WideSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        FlippableModel shortModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(ShortSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(ShortSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        FlippableModel largeModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_MAIN, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(LargeSignModel.MODEL_SECONDARY, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))}, new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_MAIN_FLIPPED, mainTexture.toMaterial(), this.colorFrom(mainTexture.tint())), new TexturedModel(LargeSignModel.MODEL_SECONDARY_FLIPPED, secondaryTexture.toMaterial(), this.colorFrom(secondaryTexture.tint()))});
        this.method_37063((class_364)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-4, 0)).scaleCenter(0.75f), this::switchToWide, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack)));
        this.method_37063((class_364)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX(), signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-11, 0)).scaleCenter(0.75f), this::switchToShort, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(shortModel, 0.0f, 0.25f, this.itemStack)));
        this.method_37063((class_364)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() + centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-3, 0)).scaleCenter(0.75f), this::switchToLarge, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(largeModel, 0.0f, 0.0f, this.itemStack)));
        Rect doneRect = new Rect(new Point(this.getCenterX(), this.field_22790 - 15), buttonsSize, Rect.XAlignment.Center, Rect.YAlignment.Bottom);
        if (this.oldSign.isPresent()) {
            int buttonsWidth = doneRect.width;
            doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.done()).method_46434(this.getCenterX() + 7, doneRect.point.y, buttonsWidth, doneRect.height).method_46431();
            class_4185 removeSignButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.signpost.remove_sign"), b -> this.removeSign()).method_46434(this.getCenterX() - 7 - buttonsWidth, doneRect.point.y, buttonsWidth, doneRect.height).method_46431();
            ((IColorableButton)removeSignButton).signpost$overrideColor(-48060);
            this.method_37063((class_364)removeSignButton);
        } else {
            doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.done()).method_46434(doneRect.point.x, doneRect.point.y, doneRect.width, doneRect.height).method_46431();
        }
        this.method_37063((class_364)doneButton);
        this.lockButton = new class_347(this.getCenterX() - 10, doneRect.point.y - 30, b -> this.lockButton.method_1895(!this.lockButton.method_1896()));
        this.lockButton.method_1895(this.oldSign.map(SignBlockPart::isLocked).orElse(false).booleanValue());
        this.method_37063((class_364)this.lockButton);
        Collection<Object> waystoneDropdownEntry = this.hasBeenInitialized ? this.waystoneDropdown.getAllEntries() : new HashSet();
        this.waystoneDropdown = new DropDownSelection<WaystoneEntry>(this.field_22793, new Point(this.getCenterX() - 15, this.getCenterY() - 55 + 20), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + 3 + DropDownSelection.size.width, 100, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.method_25429((class_364)e);
            this.hideStuffOccludedByWaystoneDropdown();
        }, o -> {
            this.method_37066((class_364)o);
            this.showStuffOccludedByWaystoneDropdown();
        }, entry -> {
            this.waystoneInputBox.method_1852(entry.entryName);
            this.waystoneDropdown.hideList();
        });
        this.waystoneDropdown.setEntries(waystoneDropdownEntry);
        Rect waystoneInputRect = new Rect(new Point(this.waystoneDropdown.method_46426() - 10, this.waystoneDropdown.method_46427() + this.waystoneDropdown.method_25364() / 2), new TextureSize((int)((float)(SignGui.waystoneNameTexture.size.width - 4) * 2.5f), (int)((float)(SignGui.waystoneNameTexture.size.height - 4) * 2.5f)), Rect.XAlignment.Right, Rect.YAlignment.Center);
        this.waystoneInputBox = new ImageInputBox(this.field_22793, waystoneInputRect, new Rect(new Point(-4, 0), SignGui.waystoneNameTexture.size.scale(2.5f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, waystoneNameTexture, true, 100.0);
        this.waystoneInputBox.method_1880(200);
        this.waystoneInputBox.method_1863(this::onWaystoneSelected);
        this.noWaystonesInfo = new TextDisplay((class_2561)class_2561.method_43471((String)"signpost.no_waystones"), this.waystoneDropdown.rect.max(), Rect.XAlignment.Right, Rect.YAlignment.Bottom, this.field_22793);
        int rotationLabelStringWidth = this.field_22793.method_1727(class_1074.method_4662((String)"gui.signpost.rotation_label", (Object[])new Object[0]));
        int rotationLabelWidth = Math.min(rotationLabelStringWidth, this.waystoneInputBox.width() / 2);
        Rect rotationInputBoxRect = waystoneInputRect.offset(new Point(rotationLabelWidth + 10, waystoneInputRect.height + 20), new Point(0, waystoneInputRect.height + 20));
        this.rotationInputField = new AngleInputBox(this.field_22793, rotationInputBoxRect, 0.0);
        this.method_37063((class_364)this.rotationInputField);
        this.angleDropDown = new DropDownSelection<AngleSelectionEntry>(this.field_22793, new Point(this.getCenterX() - 15, rotationInputBoxRect.center().y), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + DropDownSelection.size.width, 75, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.method_25429((class_364)e);
            for (class_339 class_3392 : this.overlaySelectionButtons) {
                this.method_37066((class_364)class_3392);
            }
        }, o -> {
            this.method_37066((class_364)o);
            for (class_339 class_3392 : this.overlaySelectionButtons) {
                this.method_37063((class_364)class_3392);
            }
        }, entry -> {
            this.rotationInputField.method_1852(entry.angleToString());
            this.angleDropDown.hideList();
        });
        this.angleDropDown.setEntries(new HashSet());
        this.angleDropDown.addEntry(this.angleEntryForPlayer());
        this.method_37063((class_364)this.angleDropDown);
        this.rotationLabel = new TextDisplay((class_2561)class_2561.method_43471((String)"gui.signpost.rotation_label"), rotationInputBoxRect.at(Rect.XAlignment.Left, Rect.YAlignment.Center).add(-10, 0), Rect.XAlignment.Right, Rect.YAlignment.Center, this.field_22793);
        this.method_37060(this.rotationLabel);
        Rect modelRect = new Rect(new Point(this.getCenterX() + 15 + 15, this.getCenterY() - 55), new TextureSize(22, 16).scale(5.0f), Rect.XAlignment.Left, Rect.YAlignment.Top);
        GuiModelRenderer postRenderer = new GuiModelRenderer(modelRect, postModel, 0.0f, -0.5f);
        this.method_37060(postRenderer);
        Point modelRectTop = modelRect.at(Rect.XAlignment.Center, Rect.YAlignment.Top);
        int inputBoxesZOffset = 100;
        Rect wideInputRect = new Rect(modelRectTop.add(-35, 10), modelRectTop.add(55, 30));
        this.wideSignInputBox = new InputBox(this.field_22793, wideInputRect, false, 100.0);
        this.wideSignInputBox.method_1858(false);
        this.wideSignInputBox.method_1868(-16777216);
        this.widgetsToFlip.add(new FlippableAtPivot(this.wideSignInputBox, modelRectTop.x));
        this.wideSignRenderer = new GuiModelRenderer(modelRect, wideModel, 0.0f, 0.24f);
        this.widgetsToFlip.add(this.wideSignRenderer);
        Rect shortInputRect = new Rect(modelRectTop.add(15, 10), modelRectTop.add(70, 30));
        this.shortSignInputBox = new InputBox(this.field_22793, shortInputRect, false, 100.0);
        this.shortSignInputBox.method_1858(false);
        this.shortSignInputBox.method_1868(-16777216);
        this.widgetsToFlip.add(new FlippableAtPivot(this.shortSignInputBox, modelRectTop.x));
        this.shortSignRenderer = new GuiModelRenderer(modelRect, shortModel, 0.0f, 0.24f);
        this.widgetsToFlip.add(this.shortSignRenderer);
        Rect largeInputRect = new Rect(modelRectTop.add(-35, 15), modelRectTop.add(45, 70)).withHeight(height -> height / 4 - 1);
        InputBox firstLarge = new InputBox(this.field_22793, largeInputRect, false, 100.0);
        firstLarge.method_1858(false);
        firstLarge.method_1868(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 27.5f)));
        InputBox secondLarge = new InputBox(this.field_22793, largeInputRect, false, 100.0);
        secondLarge.method_1858(false);
        secondLarge.method_1868(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 40.0f)));
        InputBox thirdLarge = new InputBox(this.field_22793, largeInputRect, false, 100.0);
        thirdLarge.method_1858(false);
        thirdLarge.method_1868(-16777216);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 52.5f)));
        InputBox fourthLarge = new InputBox(this.field_22793, largeInputRect, false, 100.0);
        fourthLarge.method_1858(false);
        fourthLarge.method_1868(-16777216);
        firstLarge.addKeyCodeListener(264, () -> this.method_48265((class_364)secondLarge));
        secondLarge.addKeyCodeListener(265, () -> this.method_48265((class_364)firstLarge));
        secondLarge.addKeyCodeListener(264, () -> this.method_48265((class_364)thirdLarge));
        thirdLarge.addKeyCodeListener(265, () -> this.method_48265((class_364)secondLarge));
        thirdLarge.addKeyCodeListener(264, () -> this.method_48265((class_364)fourthLarge));
        fourthLarge.addKeyCodeListener(265, () -> this.method_48265((class_364)thirdLarge));
        this.widgetsToFlip.add(new FlippableAtPivot(firstLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(secondLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(thirdLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(fourthLarge, modelRectTop.x));
        this.largeSignRenderer = new GuiModelRenderer(modelRect, largeModel, 0.0f, -0.01f);
        this.widgetsToFlip.add(this.largeSignRenderer);
        this.largeSignInputBoxes = ImmutableList.of((Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        this.allSignInputBoxes = ImmutableList.of((Object)this.wideSignInputBox, (Object)this.shortSignInputBox, (Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        SignpostImageButton switchDirectionButton = SignGui.newImageButton(TextureResource.flipDirection, 0, new Point(modelRect.point.x, modelRect.max().y + 15), 1.0f, Rect.XAlignment.Left, Rect.YAlignment.Top, this::flip);
        this.method_37063((class_364)switchDirectionButton);
        this.colorInputBox = new ColorInputBox(this.field_22793, new Rect(new Point(switchDirectionButton.method_46426() + switchDirectionButton.method_25368() + 20, switchDirectionButton.method_46427() + switchDirectionButton.method_25364() / 2), 80, 20, Rect.XAlignment.Left, Rect.YAlignment.Center), 0.0);
        this.colorInputBox.setColorResponder(color -> this.allSignInputBoxes.forEach(b -> b.method_1868(color)));
        this.method_37063((class_364)this.colorInputBox);
        this.overlaySelectionButtons.clear();
        int i = 0;
        for (Overlay overlay : Overlay.getAllOverlays()) {
            FlippableModel overlayModel = FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY, overlay.materialFor(SmallWideSignBlockPart.class), this.colorFrom(overlay.tint))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY_FLIPPED, overlay.materialFor(SmallWideSignBlockPart.class), this.colorFrom(overlay.tint))});
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.of(overlay)), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack), new ModelButton.ModelData(overlayModel, 0.0f, 0.25f, this.itemStack)));
            ++i;
        }
        if (i > 0) {
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.empty()), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack)));
        }
        for (class_4185 class_41852 : this.overlaySelectionButtons) {
            this.method_37063((class_364)class_41852);
        }
        this.switchTo(currentType);
        this.switchOverlay(this.selectedOverlay);
        this.waystoneInputBox.method_1852(currentWaystone);
        switch (currentType.ordinal()) {
            case 0: {
                this.wideSignInputBox.method_1852(currentText[0].get());
                break;
            }
            case 1: {
                this.shortSignInputBox.method_1852(currentText[0].get());
                break;
            }
            case 2: {
                for (i = 0; i < this.largeSignInputBoxes.size(); ++i) {
                    this.largeSignInputBoxes.get(i).method_1852(currentText[i].get());
                }
                break;
            }
        }
        if (isFlipped ^ this.widgetsToFlip.get(0).isFlipped()) {
            this.flip();
        }
        this.colorInputBox.setSelectedColor(currentColor);
        this.rotationInputField.setSelectedAngle(Angle.fromDegrees(Math.round(currentAngle.degrees())));
        if (this.hasBeenInitialized) {
            this.onWaystoneCountChanged();
        } else {
            String unknownWaystone = class_2561.method_43471((String)"gui.signpost.unknownWaystone").method_27694(style -> style.method_27703(class_5251.method_27717((int)-9408400))).getString();
            Optional<Object> optional = this.oldSign.flatMap(SignBlockPart::getDestination).map(handle -> new WaystoneEntry(unknownWaystone, unknownWaystone, (WaystoneHandle)handle, this.tile.method_11016().method_10081((class_2382)new Vector3(100.0f, 0.0f, 0.0f).rotateY(this.oldSign.get().getAngle().get()).toBlockPos())));
            optional.ifPresent(text -> {
                this.waystoneDropdown.addEntry((WaystoneEntry)text);
                this.waystoneInputBox.method_1863(x -> {});
                this.waystoneInputBox.method_1852(text.entryName);
                this.waystoneInputBox.method_1863(this::onWaystoneSelected);
            });
            Consumer<Function> setupFromSign = map -> {
                oldWaystone.ifPresent(oldWs -> {
                    Optional name = (Optional)map.apply(oldWs.handle);
                    if (name.isPresent()) {
                        oldWs.entryName = (String)((Tuple)((Tuple)name.get())._1())._1();
                        oldWs.displayName = (String)((Tuple)((Tuple)name.get())._1())._2();
                        oldWs.pos = (class_2338)((Tuple)name.get())._2();
                        this.waystoneInputBox.method_1852(oldWs.entryName);
                    }
                });
                this.onWaystoneCountChanged();
            };
            WaystoneLibrary.getInstance().requestAllWaystones(n -> {
                this.waystoneDropdown.addEntries(n.entrySet().stream().map(e -> new WaystoneEntry((String)((Tuple)e.getValue())._1(), (String)((Tuple)e.getValue())._1(), (WaystoneHandle)e.getKey(), ((WaystoneLocationData)((Tuple)e.getValue())._2()).block().blockPos())).filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> id instanceof WaystoneHandle.Vanilla ? Optional.ofNullable((Tuple)n.get(id)).map(e -> Tuple.of((String)e._1(), (String)e._1(), ((WaystoneLocationData)e._2()).block().blockPos())) : Optional.empty());
            }, Optional.of(PlayerHandle.from((class_1297)this.field_22787.field_1724)), true);
            ExternalWaystoneLibrary.getInstance().requestKnownWaystones(n -> {
                List entries = n.stream().map(w -> new WaystoneEntry(w.name() + " " + w.handle().modMark(), w.name(), w.handle(), w.loc().block().blockPos())).collect(Collectors.toList());
                this.waystoneDropdown.addEntries(entries.stream().filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> entries.stream().filter(e -> e.handle.equals(id)).findFirst().map(e -> Tuple.of(e.entryName, e.displayName, e.pos)));
            });
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        }
        int newSignItemSize = 16;
        TextDisplay textDisplay = new TextDisplay((class_2561)class_2561.method_43471((String)"gui.signpost.new_sign_hint"), new Point(this.getCenterX() - 16, (int)((float)(doneButton.method_46427() + doneButton.method_25364() + this.field_22790) / 2.0f)), Rect.XAlignment.Center, Rect.YAlignment.Center, this.field_22793);
        this.method_37060(textDisplay);
        GuiItemRenderer ir = new GuiItemRenderer(new Rect(textDisplay.rect.at(Rect.XAlignment.Right, Rect.YAlignment.Center), 16, 16, Rect.XAlignment.Left, Rect.YAlignment.Center), class_1799.field_8037);
        this.method_37060((class_4068)ir);
        AtomicReference<Runnable> cycleItem = new AtomicReference<Runnable>();
        AtomicInteger cycleItemIndex = new AtomicInteger(0);
        AtomicInteger cycleItemIngredientIndex = new AtomicInteger(0);
        AtomicLong nextCycleAt = new AtomicLong(System.currentTimeMillis());
        cycleItem.set(() -> {
            if (this.isClosed) {
                return;
            }
            List options = PostBlock.AllVariants.get((int)cycleItemIndex.get()).type.addSignIngredient.apply((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()).method_8105().toList();
            ir.setItemStack(new class_1799((class_1935)((class_6880)options.get(cycleItemIngredientIndex.get())).comp_349()));
            if (cycleItemIngredientIndex.get() >= options.size() - 1) {
                cycleItemIndex.set((cycleItemIndex.get() + 1) % PostBlock.AllVariants.size());
                cycleItemIngredientIndex.set(0);
            } else {
                cycleItemIngredientIndex.incrementAndGet();
            }
            nextCycleAt.set(nextCycleAt.get() + (long)(options.size() < 2 ? 1500 : (options.size() == 2 ? 1000 : 500)));
            IDelay.onClientUntil(() -> System.currentTimeMillis() >= nextCycleAt.get(), () -> ((Runnable)cycleItem.get()).run());
        });
        ((Runnable)cycleItem.get()).run();
        this.hasBeenInitialized = true;
        this.method_25395((class_364)this.currentSignInputBox);
        this.currentSignInputBox.method_25365(true);
    }

    private void onWaystoneCountChanged() {
        if (this.waystoneDropdown.getAllEntries().isEmpty()) {
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.noWaystonesInfo)) {
                this.method_37060(this.noWaystonesInfo);
            }
            this.method_37066((class_364)this.waystoneDropdown);
            this.method_37066((class_364)this.waystoneInputBox);
        } else {
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.waystoneDropdown)) {
                this.method_37063((class_364)this.waystoneDropdown);
            }
            if (!((ScreenAccessor)((Object)this)).getRenderables().contains(this.waystoneInputBox)) {
                this.method_37063((class_364)this.waystoneInputBox);
            }
            ((ScreenAccessor)((Object)this)).getRenderables().remove(this.noWaystonesInfo);
        }
    }

    private void flip() {
        AngleSelectionEntry playerAngleEntry = this.angleEntryForPlayer();
        boolean shouldPointAtPlayer = Math.round(Math.abs(playerAngleEntry.angleGetter.get().degrees() - this.rotationInputField.getCurrentAngle().degrees())) <= 1;
        this.widgetsToFlip.forEach(Flippable::flip);
        if (shouldPointAtPlayer) {
            this.rotationInputField.method_1852(playerAngleEntry.angleToString());
        }
    }

    private void onWaystoneSelected(String waystoneName) {
        boolean shouldOverrideRotation;
        boolean bl = shouldOverrideRotation = this.isCurrentAnglePointingAtWaystone() || this.isCurrentAnglePointingAtPlayer();
        if (this.waystoneRotationEntry != null) {
            shouldOverrideRotation |= this.waystoneRotationEntry.angleGetter.get().isNearly(this.rotationInputField.getCurrentAngle(), Angle.fromDegrees(1.0f));
            this.angleDropDown.removeEntry(this.waystoneRotationEntry);
        }
        Optional<WaystoneEntry> validWaystone = this.asValidWaystone(waystoneName);
        if (waystoneName.equals("") || validWaystone.isPresent()) {
            this.waystoneInputBox.method_1868(-1);
            this.waystoneInputBox.method_1860(-2236963);
            this.waystoneDropdown.setFilter(name -> true);
            if (this.currentSignInputBox != null && this.lastWaystone.map(lw -> lw.displayName.equals(this.currentSignInputBox.method_1882())).orElse(this.currentSignInputBox.method_1882().equals("")).booleanValue()) {
                this.currentSignInputBox.method_1852(validWaystone.map(e -> e.displayName).orElse(waystoneName));
            }
            if (!waystoneName.equals("")) {
                this.waystoneRotationEntry = this.angleEntryForWaystone(validWaystone.get());
                this.angleDropDown.addEntry(this.waystoneRotationEntry);
                if (shouldOverrideRotation) {
                    this.rotationInputField.setSelectedAngle(this.waystoneRotationEntry.angleGetter.get());
                }
            }
            this.lastWaystone = validWaystone;
        } else {
            this.waystoneInputBox.method_1868(-48060);
            this.waystoneInputBox.method_1860(-2267546);
            this.waystoneDropdown.setFilter(e -> e.entryName.toLowerCase().contains(waystoneName.toLowerCase()));
            if (this.currentSignInputBox != null && this.lastWaystone.map(lw -> lw.displayName.equals(this.currentSignInputBox.method_1882())).orElse(this.currentSignInputBox.method_1882().equals("")).booleanValue()) {
                this.currentSignInputBox.method_1852("");
            }
        }
    }

    private int colorFrom(Optional<Tint> tint) {
        return tint.map(t -> t.getColorAt((class_1920)this.field_22787.field_1687, this.field_22787.field_1724.method_24515())).orElse(-1);
    }

    private boolean isCurrentAnglePointingAtWaystone() {
        return !this.oldSign.isPresent() && this.rotationInputField.getCurrentAngle().equals(Angle.ZERO) || this.lastWaystone.map(lw -> this.rotationInputField.getCurrentAngle().isNearly(this.angleEntryForWaystone((WaystoneEntry)lw).angleGetter.get(), Angle.fromDegrees(1.0f))).orElse(false) != false;
    }

    private boolean isCurrentAnglePointingAtPlayer() {
        return this.rotationInputField.getCurrentAngle().isNearly(this.angleEntryForPlayer().angleGetter.get(), Angle.fromDegrees(1.0f));
    }

    private Optional<WaystoneEntry> asValidWaystone(String name) {
        Optional<WaystoneEntry> ret = this.waystoneDropdown.getAllEntries().stream().filter(e -> e.entryName.equals(name)).findFirst();
        if (ret.isPresent()) {
            return ret;
        }
        return this.waystoneDropdown.getAllEntries().stream().filter(e -> e.displayName.equals(name)).findFirst();
    }

    private static SignpostImageButton newImageButton(TextureResource texture, int index, Point referencePoint, float scale, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Runnable onClick) {
        Rect rect = new Rect(referencePoint, texture.size.scale(scale), xAlignment, yAlignment);
        return new SignpostImageButton(texture, rect, b -> onClick.run());
    }

    private int getCenterX() {
        return this.field_22789 / 2;
    }

    private int getCenterY() {
        return this.field_22790 / 2;
    }

    private void switchTo(SignType type) {
        switch (type.ordinal()) {
            case 0: {
                this.switchToWide();
                break;
            }
            case 1: {
                this.switchToShort();
                break;
            }
            case 2: {
                this.switchToLarge();
                break;
            }
            default: {
                throw new RuntimeException("Sign type " + String.valueOf((Object)type) + " is not supported");
            }
        }
    }

    private void switchToWide() {
        if (this.selectedType == SignType.Wide) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Wide;
        this.switchSignInputBoxTo(this.wideSignInputBox);
        this.method_37060(this.wideSignRenderer);
        this.addTypeDependentChild((class_339)this.wideSignInputBox);
        this.currentSignRenderer = this.wideSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToShort() {
        if (this.selectedType == SignType.Short) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Short;
        this.switchSignInputBoxTo(this.shortSignInputBox);
        this.method_37060(this.shortSignRenderer);
        this.addTypeDependentChild((class_339)this.shortSignInputBox);
        this.currentSignRenderer = this.shortSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToLarge() {
        if (this.selectedType == SignType.Large) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Large;
        this.switchSignInputBoxTo(this.largeSignInputBoxes.get(0));
        this.method_37060(this.largeSignRenderer);
        this.addTypeDependentChildren(this.largeSignInputBoxes);
        this.currentSignRenderer = this.largeSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchOverlay(Optional<Overlay> overlay) {
        if (this.currentOverlay != null) {
            ((ScreenAccessor)((Object)this)).getRenderables().remove(this.currentOverlay);
            this.widgetsToFlip.remove(this.currentOverlay);
        }
        this.selectedOverlay = overlay;
        if (!overlay.isPresent()) {
            return;
        }
        Overlay o = overlay.get();
        switch (this.selectedType.ordinal()) {
            case 0: {
                this.currentOverlay = new GuiModelRenderer(this.wideSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY, o.materialFor(SmallWideSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(WideSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(SmallWideSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.25f);
                break;
            }
            case 1: {
                this.currentOverlay = new GuiModelRenderer(this.shortSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_OVERLAY, o.materialFor(SmallShortSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(ShortSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(SmallShortSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.25f);
                break;
            }
            case 2: {
                this.currentOverlay = new GuiModelRenderer(this.largeSignRenderer.rect, FlippableModel.from(new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_OVERLAY, o.materialFor(LargeSignBlockPart.class), this.colorFrom(o.tint))}, new TexturedModel[]{new TexturedModel(LargeSignModel.MODEL_OVERLAY_FLIPPED, o.materialFor(LargeSignBlockPart.class), this.colorFrom(o.tint))}), 0.0f, 0.0f);
            }
        }
        this.method_37060(this.currentOverlay);
        if (this.currentSignRenderer.isFlipped()) {
            this.currentOverlay.flip();
        }
        this.widgetsToFlip.add(this.currentOverlay);
    }

    private void hideStuffOccludedByWaystoneDropdown() {
        ((ScreenAccessor)((Object)this)).getRenderables().remove(this.rotationLabel);
        this.method_37066((class_364)this.rotationInputField);
        this.angleDropDown.hideList();
        this.method_37066((class_364)this.angleDropDown);
        for (class_4185 class_41852 : this.overlaySelectionButtons) {
            this.method_37066((class_364)class_41852);
        }
    }

    private void showStuffOccludedByWaystoneDropdown() {
        this.method_37060(this.rotationLabel);
        this.method_37063((class_364)this.rotationInputField);
        this.method_37063((class_364)this.angleDropDown);
        for (class_4185 class_41852 : this.overlaySelectionButtons) {
            this.method_37063((class_364)class_41852);
        }
    }

    private void switchSignInputBoxTo(InputBox box) {
        if (this.currentSignInputBox != null) {
            box.method_1852(this.currentSignInputBox.method_1882());
        }
        this.currentSignInputBox = box;
    }

    private void clearTypeDependentChildren() {
        for (class_339 b : this.selectionDependentWidgets) {
            this.method_37066((class_364)b);
        }
        ((ScreenAccessor)((Object)this)).getRenderables().remove(this.currentSignRenderer);
        this.selectionDependentWidgets.clear();
    }

    private void addTypeDependentChildren(Collection<? extends class_339> widgets) {
        this.selectionDependentWidgets.addAll(widgets);
        for (class_339 class_3392 : widgets) {
            this.method_37063((class_364)class_3392);
        }
    }

    private void addTypeDependentChild(class_339 widget) {
        this.selectionDependentWidgets.add(widget);
        this.method_37063((class_364)widget);
    }

    public void method_25419() {
        super.method_25419();
        this.isClosed = true;
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void removeSign() {
        if (this.oldSign.isPresent()) {
            PacketHandler.getInstance().sendToServer(new PostTile.PartRemovedEvent.Packet(this.oldTilePartInfo.get(), true));
        } else {
            Signpost.LOGGER.error("Tried to remove a sign, but the necessary information was missing.");
        }
        this.field_22787.method_1507(null);
    }

    private void done() {
        this.apply(this.asValidWaystone(this.waystoneInputBox.method_1882()).map(w -> w.handle));
        this.field_22787.method_1507(null);
        this.isClosed = true;
    }

    private void apply(Optional<WaystoneHandle> destinationId) {
        PostTile.TilePartInfo tilePartInfo = this.oldTilePartInfo.orElseGet(() -> new PostTile.TilePartInfo(this.tile.method_10997().method_27983().method_29177(), this.tile.method_11016(), UUID.randomUUID()));
        class_5455 registries = this.tile.method_10997().method_30349();
        boolean isLocked = this.lockButton.method_1896();
        Texture mainTex = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        Texture secondaryTex = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        AngleProvider angle = destinationId.flatMap(destination -> this.isCurrentAnglePointingAtWaystone() ? Optional.of(new AngleProvider.WaystoneTarget(this.rotationInputField.getCurrentAngle())) : Optional.empty()).orElseGet(() -> new AngleProvider.Literal(this.rotationInputField.getCurrentAngle()));
        switch (this.selectedType.ordinal()) {
            case 0: {
                SmallWideSignBlockPart data = new SmallWideSignBlockPart(angle, this.asNameProvider(this.wideSignInputBox.method_1882()), this.wideSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, SmallWideSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)), this.itemToDropOnBreak.orElse(class_1799.field_8037), PlayerHandle.from((class_1297)this.field_22787.field_1724)));
                break;
            }
            case 1: {
                SmallShortSignBlockPart data = new SmallShortSignBlockPart(angle, this.asNameProvider(this.shortSignInputBox.method_1882()), this.shortSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, SmallShortSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, this.localHitPos.y() > 0.5f ? 0.75f : 0.25f, 0.0f)), this.itemToDropOnBreak.orElse(class_1799.field_8037), PlayerHandle.from((class_1297)this.field_22787.field_1724)));
                break;
            }
            case 2: {
                LargeSignBlockPart data = new LargeSignBlockPart(angle, new NameProvider[]{this.asNameProvider(this.largeSignInputBoxes.get(0).method_1882()), this.asNameProvider(this.largeSignInputBoxes.get(1).method_1882()), this.asNameProvider(this.largeSignInputBoxes.get(2).method_1882()), this.asNameProvider(this.largeSignInputBoxes.get(3).method_1882())}, this.currentSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked, this.oldSign.map(SignBlockPart::isMarkedForGeneration).orElse(false));
                if (this.oldSign.isPresent()) {
                    PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, (BlockPart)data, LargeSignBlockPart.METADATA.identifier(), new Vector3(0.0f, this.localHitPos.y() >= 0.5f ? 0.501f : 0.499f, 0.0f)));
                    break;
                }
                PacketHandler.getInstance().sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, new BlockPartInstance(data, new Vector3(0.0f, 0.5f, 0.0f)), this.itemToDropOnBreak.orElse(class_1799.field_8037), PlayerHandle.from((class_1297)this.field_22787.field_1724)));
            }
        }
    }

    private AngleSelectionEntry angleEntryForWaystone(WaystoneEntry waystone) {
        AtomicReference<Angle> angle = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        angle.set(SignBlockPart.pointingAt(this.tile.method_11016(), waystone.pos));
        return new AngleSelectionEntry("gui.signpost.rotation_waystone", angle::get);
    }

    private AngleSelectionEntry angleEntryForPlayer() {
        AtomicReference<Angle> angleWhenFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        AtomicReference<Angle> angleWhenNotFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        IDelay.onClientUntil(() -> this.field_22787 != null && this.field_22787.field_1724 != null, () -> {
            angleWhenFlipped.set(Angle.fromDegrees(-this.field_22787.field_1724.method_36454()).normalized());
            angleWhenNotFlipped.set(((Angle)angleWhenFlipped.get()).add(Angle.fromRadians((float)Math.PI)).normalized());
            if (!this.oldSign.isPresent() && this.rotationInputField.getCurrentAngle().equals(Angle.ZERO)) {
                IDelay.onClientUntil(() -> this.widgetsToFlip.size() > 0, () -> this.rotationInputField.setSelectedAngle((Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get()), 100, Optional.empty());
            }
        });
        return new AngleSelectionEntry("gui.signpost.rotation_player", () -> (Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get());
    }

    private NameProvider asNameProvider(String name) {
        return this.lastWaystone.map(lw -> lw.entryName.equals(name)).orElse(false) != false ? new NameProvider.WaystoneTarget(name) : new NameProvider.Literal(name);
    }

    private static enum SignType {
        Wide,
        Short,
        Large;

    }

    private static class AngleSelectionEntry {
        private final String langKey;
        public final Supplier<Angle> angleGetter;

        private AngleSelectionEntry(String langKey, Supplier<Angle> angleGetter) {
            this.langKey = langKey;
            this.angleGetter = angleGetter;
        }

        public String angleToString() {
            return Math.round(this.angleGetter.get().degrees()) + AngleInputBox.degreeSign;
        }

        public String toString() {
            return class_1074.method_4662((String)this.langKey, (Object[])new Object[]{this.angleToString()});
        }
    }
}

