/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_347;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class WaystoneGui
extends class_437 {
    private final WorldLocation location;
    private final Optional<WaystoneData> oldData;
    private ImageInputBox inputBox;
    private Optional<Set<String>> allWaystoneNames = Optional.empty();
    private static final TextureResource texture = TextureResource.waystoneNameField;
    private static final int inputBoxScale = 3;
    private static final int inputBoxYOffset = -46;
    private static final int buttonsYOffset = 46;
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private class_347 lockButton;
    private class_4185 doneButton;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> this.allWaystoneNames.ifPresent(names -> {
        switch (event.getType()) {
            case Added: {
                names.add(event.name);
                break;
            }
            case Removed: {
                names.remove(event.name);
                break;
            }
            case Renamed: {
                names.remove(((WaystoneRenamedEvent)event).oldName);
                names.add(event.name);
            }
        }
    });

    public WaystoneGui(WorldLocation location, Optional<WaystoneData> oldData) {
        super((class_2561)class_2561.method_43470((String)"Waystone"));
        this.location = location;
        this.oldData = oldData;
    }

    public static void display(WorldLocation location, Optional<WaystoneData> oldData) {
        class_310.method_1551().method_1507((class_437)new WaystoneGui(location, oldData));
    }

    private int getCenterX() {
        return this.field_22789 / 2;
    }

    private int getCenterY() {
        return this.field_22790 / 2;
    }

    protected void method_25426() {
        super.method_25426();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> {
            this.allWaystoneNames = Optional.of(new HashSet(names.values()));
        }, Optional.empty(), true);
        WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        Point point = new Point(this.getCenterX(), this.getCenterY() + -46);
        int n = (WaystoneGui.texture.size.width - 6) * 3;
        Objects.requireNonNull(this.field_22793);
        this.inputBox = new ImageInputBox(this.field_22793, new Rect(point, new TextureSize(n, 9), Rect.XAlignment.Center, Rect.YAlignment.Bottom), new Rect(Point.zero, WaystoneGui.texture.size.scale(3.0f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, texture, true, 0.0);
        this.lockButton = new class_347(this.inputBox.method_46426() + this.inputBox.width() + 10, this.inputBox.method_46427() + this.inputBox.method_25364() / 2 - 10, b -> this.lockButton.method_1895(!this.lockButton.method_1896()));
        this.method_37063((class_364)this.lockButton);
        this.oldData.ifPresent(data -> {
            this.inputBox.method_1852(data.name());
            this.lockButton.method_1895(data.isLocked());
        });
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.done()).method_46434(this.getCenterX() - WaystoneGui.buttonsSize.width / 2, this.getCenterY() - WaystoneGui.buttonsSize.height / 2 + 46, WaystoneGui.buttonsSize.width, WaystoneGui.buttonsSize.height).method_46431();
        this.method_37063((class_364)this.inputBox);
        this.method_37063((class_364)this.doneButton);
        this.inputBox.method_1868(-1);
        this.inputBox.method_1860(-2236963);
        this.inputBox.method_1880(200);
        this.inputBox.method_1863(name -> {
            if (this.isValid((String)name)) {
                this.inputBox.method_1868(-1);
                this.inputBox.method_1860(-2236963);
                this.doneButton.field_22763 = true;
            } else {
                this.inputBox.method_1868(-48060);
                this.inputBox.method_1860(-2267546);
                this.doneButton.field_22763 = false;
            }
        });
        this.method_48265((class_364)this.inputBox);
    }

    private boolean isValid(String name) {
        return this.allWaystoneNames.map(names -> !names.contains(name)).orElse(true) != false || this.oldData.isPresent() && this.oldData.get().name().equals(name);
    }

    public void method_25419() {
        super.method_25419();
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void done() {
        if (this.inputBox != null && !this.inputBox.method_1882().equals("") && this.isValid(this.inputBox.method_1882())) {
            WaystoneLibrary.getInstance().requestUpdate(this.inputBox.method_1882(), new WaystoneLocationData(this.location, Vector3.fromVec3d(this.field_22787.field_1724.method_73189())), this.lockButton.method_1896());
        }
        this.method_25419();
    }
}

