/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ColorInputBox
extends InputBox {
    private int currentResult;

    public ColorInputBox(class_327 fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, zOffset);
        this.method_1890(null);
        this.method_1863(null);
        this.method_1852("#000000");
    }

    private static boolean isValidColor(String text) {
        return text.startsWith("#") && text.length() <= 7 && ColorInputBox.canParse(text.substring(1));
    }

    public void method_1890(Predicate<String> filter) {
        super.method_1890(text -> ColorInputBox.isValidColor(text) && (filter == null || filter.test((String)text)));
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        try {
            Integer.parseInt(text, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getResult() {
        if (this.method_1882().equals("#")) {
            return 0;
        }
        return Integer.parseInt(this.method_1882().substring(1), 16);
    }

    public int getCurrentColor() {
        return Colors.withAlpha(this.currentResult, 255);
    }

    public void method_1863(Consumer<String> responder) {
        super.method_1863(text -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)text);
            }
        });
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25291(class_10799.field_56883, TextureResource.paintBackground.location, this.method_46426() - this.field_22759, this.method_46427(), 0.0f, 0.0f, this.field_22759, this.field_22759, TextureResource.paintBackground.size.width, TextureResource.paintBackground.size.height, this.getCurrentColor());
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
    }

    public void setColorResponder(Consumer<Integer> responder) {
        this.method_1863(text -> {
            if (responder != null) {
                responder.accept(this.getCurrentColor());
            }
        });
    }

    public void setSelectedColor(int color) {
        Object text = Integer.toHexString(color);
        if (((String)text).length() < 6) {
            text = String.join((CharSequence)"", Collections.nCopies(6 - ((String)text).length(), "0")) + (String)text;
        }
        this.method_1852("#" + (String)text);
    }
}

