/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4280;
import net.minecraft.class_8666;

public class DropDownSelection<EntryType>
extends class_344 {
    public final Rect rect;
    private static final TextureResource texture = TextureResource.expandContract;
    public static final TextureSize size = new TextureSize(11, 11);
    private final Consumer<List> onShow;
    private final Consumer<List> onHide;
    private final Consumer<EntryType> onSelectionChanged;
    private final class_327 fontRenderer;
    private boolean isListVisible;
    private final List list;
    private final java.util.List<EntryType> allEntries = new ArrayList<EntryType>();
    private Predicate<EntryType> filter = b -> true;
    private int selectedIndex;

    public Collection<EntryType> getAllEntries() {
        return this.allEntries;
    }

    public Optional<EntryType> getSelectedEntry() {
        List.Entry selectedEntry = (List.Entry)this.list.method_25334();
        if (selectedEntry == null) {
            return Optional.empty();
        }
        return Optional.of(selectedEntry.content);
    }

    public void setFilter(Predicate<EntryType> filter) {
        this.filter = filter;
        this.list.updateContent();
    }

    public DropDownSelection(class_327 fontRenderer, Point position, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged) {
        this(fontRenderer, new Rect(position, size, xAlignment, yAlignment), width, height, yOffset, onShow, onHide, onSelectionChanged);
    }

    private DropDownSelection(class_327 fontRenderer, Rect rect, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, new class_8666(DropDownSelection.texture.location, DropDownSelection.texture.location), b -> ((DropDownSelection)b).toggle());
        this.rect = rect;
        this.fontRenderer = fontRenderer;
        this.list = new List(this, class_310.method_1551(), new Point(rect.point.x + DropDownSelection.size.width, rect.point.y + DropDownSelection.size.height + yOffset), width, height);
        this.onSelectionChanged = onSelectionChanged;
        this.onShow = onShow;
        this.onHide = onHide;
    }

    public void addEntry(EntryType text) {
        if (!this.allEntries.contains(text)) {
            this.allEntries.add(text);
            this.list.updateContent();
        }
    }

    public void removeEntry(EntryType text) {
        if (this.allEntries.contains(text)) {
            this.allEntries.remove(text);
            this.list.updateContent();
        }
    }

    public void setEntries(Collection<EntryType> entries) {
        this.allEntries.clear();
        this.addEntries(entries);
    }

    public void addEntries(Collection<EntryType> entries) {
        this.allEntries.addAll(entries);
        this.list.updateContent();
    }

    public void toggle() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        } else {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void showList() {
        if (!this.isListVisible) {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void hideList() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        }
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().pushMatrix();
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        int yTexStart = this.field_22762 ? DropDownSelection.texture.size.height : 0;
        int xTexStart = this.isListVisible ? DropDownSelection.texture.size.width : 0;
        graphics.method_25290(class_10799.field_56883, DropDownSelection.texture.location, this.method_46426(), this.method_46427(), (float)xTexStart, (float)yTexStart, this.field_22758, this.field_22759, DropDownSelection.texture.fileSize.height, DropDownSelection.texture.fileSize.width);
        if (this.isListVisible) {
            this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_51448().popMatrix();
    }

    public class List
    extends class_4280<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
        private final int rimHeight;
        final /* synthetic */ DropDownSelection this$0;

        public List(DropDownSelection this$0, class_310 minecraft, Point topRight, int width, int height) {
            Objects.requireNonNull(minecraft.field_1772);
            this(this$0, minecraft, topRight, width, height, 9);
        }

        public List(DropDownSelection this$0, class_310 minecraft, Point topRight, int width, int height, int rimHeight) {
            this.this$0 = this$0;
            super(minecraft, width, height, topRight.y + rimHeight, 14);
            this.method_46421(topRight.x - width);
            this.rimHeight = rimHeight;
            this.updateContent();
        }

        public void updateContent() {
            this.method_25314(this.this$0.allEntries.stream().filter(this.this$0.filter).map(x$0 -> new Entry(x$0)).collect(Collectors.toList()));
            this.method_44382(this.method_44387());
        }

        public int method_25322() {
            return this.field_22758;
        }

        public class Entry
        extends class_4280.class_4281<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
            private final EntryType content;

            public Entry(EntryType content) {
                this.content = content;
            }

            public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                int brightness = 255;
                if (isHovering) {
                    brightness = (int)((float)brightness * 0.6f);
                }
                RenderingUtil.drawString(graphics, List.this.this$0.fontRenderer, this.content.toString(), new Point(this.method_73380(), this.method_73382()), Rect.XAlignment.Center, Rect.YAlignment.Top, Colors.from(brightness, brightness, brightness), List.this.field_22758 - 6, true);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)"");
            }

            public boolean method_25402(class_11909 p_446815_, boolean p_432750_) {
                List.this.this$0.selectedIndex = List.this.this$0.allEntries.indexOf(this.content);
                List.this.this$0.onSelectionChanged.accept(this.content);
                return true;
            }
        }
    }
}

