/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import net.minecraft.class_10799;
import net.minecraft.class_327;
import net.minecraft.class_332;

public final class ImageInputBox
extends InputBox
implements Flippable {
    private final TextureResource texture;
    private Rect backgroundRect;
    public final Rect bounds;
    private boolean isFlipped = false;

    public ImageInputBox(class_327 fontRenderer, Rect inputFieldRect, Rect backgroundRect, Rect.XAlignment backXAlignment, Rect.YAlignment backYAlignment, TextureResource texture, boolean shouldDropShadow, double zOffset) {
        super(fontRenderer, inputFieldRect, shouldDropShadow, zOffset);
        this.texture = texture;
        this.method_1858(false);
        this.method_1868(-16777216);
        int x = backgroundRect.point.x + inputFieldRect.point.x;
        switch (backXAlignment) {
            case Center: {
                x += inputFieldRect.width / 2;
                break;
            }
            case Right: {
                x += inputFieldRect.width;
            }
        }
        int y = backgroundRect.point.y + inputFieldRect.point.y;
        switch (backYAlignment) {
            case Center: {
                y += inputFieldRect.height / 2;
                break;
            }
            case Bottom: {
                y += inputFieldRect.height;
            }
        }
        this.backgroundRect = new Rect(new Point(x, y), backgroundRect.width, backgroundRect.height);
        this.bounds = new Rect(Point.min(inputFieldRect.min(), this.backgroundRect.min()), Point.max(inputFieldRect.max(), this.backgroundRect.max()));
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25290(class_10799.field_56883, this.texture.location, this.backgroundRect.point.x, this.backgroundRect.point.y, 0.0f, 0.0f, this.backgroundRect.width, this.backgroundRect.height, this.isFlipped ? -this.backgroundRect.width : this.backgroundRect.width, this.backgroundRect.height);
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        if (isFlipped != this.isFlipped) {
            this.backgroundRect = this.backgroundRect.withPoint(p -> p.withX(oldX -> this.method_46426() + (this.method_46426() + this.field_22758) - (this.backgroundRect.point.x + this.backgroundRect.width)));
        }
        this.isFlipped = isFlipped;
    }
}

