/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.WithMutableX;
import gollorum.signpost.mixin.GuiGraphicsMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class InputBox
extends class_342
implements WithMutableX {
    private boolean shouldDropShadow;
    private final class_327 configFont;
    private final List<Function<Integer, Boolean>> keyCodeConsumers = new ArrayList<Function<Integer, Boolean>>();
    private final double zOffset;

    public InputBox(class_327 configFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset) {
        this(configFont, inputFieldRect, shouldDropShadow, zOffset, 500);
    }

    private InputBox(class_327 copyFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset, int maxStringLength) {
        super(copyFont, inputFieldRect.point.x, inputFieldRect.point.y, inputFieldRect.width, inputFieldRect.height, (class_2561)class_2561.method_43470((String)""));
        this.configFont = copyFont;
        this.shouldDropShadow = shouldDropShadow;
        this.method_71503(shouldDropShadow);
        this.zOffset = zOffset;
        this.method_1880(maxStringLength);
    }

    public boolean method_25404(class_11908 event) {
        for (Function<Integer, Boolean> consumer : this.keyCodeConsumers) {
            if (!consumer.apply(event.comp_4795()).booleanValue()) continue;
            return true;
        }
        return super.method_25404(event);
    }

    public void addKeyCodeListener(int keyCode, Runnable action) {
        this.keyCodeConsumers.add(i -> {
            if (i == keyCode) {
                action.run();
                return true;
            }
            return false;
        });
    }

    public void method_48579(class_332 graphics, int p_94161_, int p_94162_, float p_94163_) {
        if (!this.shouldDropShadow) {
            graphics = new NoShadowGuiGraphics(this, graphics);
        }
        if (this.field_22762 && !this.method_1851()) {
            int n = this.method_46427();
            Objects.requireNonNull(this.configFont);
            int fromY = n + (9 - this.field_22759) / 2;
            graphics.method_48196(class_10799.field_56879, this.method_46426(), fromY, this.method_46426() + this.field_22758, fromY + this.field_22759, 0x40FFFFFF);
        }
        super.method_48579(graphics, p_94161_, p_94162_, p_94163_);
    }

    public void method_1858(boolean shouldBeBordered) {
        super.method_1858(shouldBeBordered);
        this.method_46419(this.method_46427() + (shouldBeBordered ? -(this.field_22759 - 8) / 2 : (this.field_22759 - 8) / 2));
    }

    @Override
    public int getXPos() {
        return this.method_46426();
    }

    @Override
    public int width() {
        return this.field_22758;
    }

    @Override
    public void setXPos(int x) {
        this.method_46421(x);
    }

    private class NoShadowGuiGraphics
    extends class_332 {
        public NoShadowGuiGraphics(InputBox inputBox, class_332 original) {
            super(class_310.method_1551(), ((GuiGraphicsMixin)original).getGuiRenderState());
        }

        public void method_25303(class_327 font, @Nullable String text, int x, int y, int color) {
            super.method_51433(font, text, x, y, color, false);
        }

        public void method_35720(class_327 font, class_5481 text, int x, int y, int color) {
            super.method_51430(font, text, x, y, color, false);
        }

        public void method_27535(class_327 font, class_2561 text, int x, int y, int color) {
            super.method_51439(font, text, x, y, color, false);
        }

        public void method_65179(class_327 font, class_5348 text, int x, int y, int lineWidth, int color) {
            this.method_51440(font, text, x, y, lineWidth, color, false);
        }
    }
}

