/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.GuiModelRenderer;
import gollorum.signpost.minecraft.gui.widgets.SignpostImageButton;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class ModelButton
extends SignpostImageButton {
    private final List<GuiModelRenderer> modelRenderers;
    private final TextureResource background;

    public ModelButton(TextureResource background, Point point, float scale, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Function<Rect, Rect> rectBuilder, Runnable onPress, ModelData ... modelData) {
        this(background, new Rect(point, background.size.scale(scale), xAlignment, yAlignment), scale, rectBuilder, b -> onPress.run(), modelData);
    }

    private ModelButton(TextureResource background, Rect rect, float scale, Function<Rect, Rect> rectBuilder, class_4185.class_4241 onPress, ModelData ... modelData) {
        super(background, rect, onPress);
        this.background = background;
        this.modelRenderers = new ArrayList<GuiModelRenderer>();
        for (ModelData model : modelData) {
            this.modelRenderers.add(new GuiModelRenderer(rectBuilder.apply(rect), model.model, model.modelSpaceXOffset, model.modelSpaceYOffset));
        }
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        for (GuiModelRenderer model : this.modelRenderers) {
            model.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public static class ModelData {
        public final FlippableModel model;
        public final float modelSpaceXOffset;
        public final float modelSpaceYOffset;
        public final class_1799 itemStack;

        public ModelData(FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, class_1799 itemStack) {
            this.model = model;
            this.modelSpaceXOffset = modelSpaceXOffset;
            this.modelSpaceYOffset = modelSpaceYOffset;
            this.itemStack = itemStack;
        }
    }
}

