/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.loot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.platform.Services;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_2586;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import org.jetbrains.annotations.NotNull;

public final class PermissionCheck
implements class_5341 {
    private final Type type;

    public static class_5342 createConditionType() {
        return new class_5342(Codec.STRING.fieldOf("type").flatXmap(str -> Arrays.stream(Type.values()).filter(t -> t.name.equals(str)).findFirst().map(PermissionCheck::new).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown permission check type: " + str)), check -> DataResult.success((Object)check.type.name)));
    }

    public PermissionCheck(Type type) {
        this.type = type;
    }

    public class_5342 method_29325() {
        return Services.LOOT_ITEM_CONDITION_REGISTRY.getPermissionCheck();
    }

    public boolean test(class_47 lootContext) {
        if (!lootContext.method_300(class_181.field_1233)) {
            return true;
        }
        class_1657 thisEntity = (class_1657)lootContext.method_35508(class_181.field_1233);
        if (thisEntity.method_64475(IConfig.IServer.getInstance().permissions().pickUnownedWaystonePermissionLevel())) {
            return true;
        }
        if (!lootContext.method_300(class_181.field_1228)) {
            return false;
        }
        class_2586 blockEntity = (class_2586)lootContext.method_35508(class_181.field_1228);
        if (!(blockEntity instanceof WaystoneTile)) {
            return false;
        }
        WaystoneTile waystoneTile = (WaystoneTile)blockEntity;
        return waystoneTile.getWaystoneOwner().map(owner -> owner.equals(PlayerHandle.from((class_1297)thisEntity))).orElse(true);
    }

    public static enum Type {
        CanPickWaystone("pick_waystone");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }

    public static class Builder
    implements class_5341.class_210 {
        private final Type type;

        public Builder(Type type) {
            this.type = type;
        }

        @NotNull
        public PermissionCheck build() {
            return new PermissionCheck(this.type);
        }
    }
}

