/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.models.modelGeneration;

import gollorum.signpost.minecraft.models.modelGeneration.Cube;
import gollorum.signpost.minecraft.models.modelGeneration.CubeFacesData;
import gollorum.signpost.minecraft.models.modelGeneration.FaceData;
import gollorum.signpost.minecraft.models.modelGeneration.FaceRotation;
import gollorum.signpost.minecraft.models.modelGeneration.Quad;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.models.modelGeneration.TextureArea;
import gollorum.signpost.minecraft.models.modelGeneration.TextureSegment;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class SignModelFactory<TextureIdentifier> {
    private final List<Cube<TextureIdentifier>> cubes = new ArrayList<Cube<TextureIdentifier>>();
    private static final float overlayOffset = 0.1f;
    private static final FaceRotation signTextureRotation = FaceRotation.Clockwise90;

    public SignModelFactory<TextureIdentifier> addCube(Vector3 min, Vector3 max, Map<class_2350, FaceData<TextureIdentifier>> sides) {
        this.cubes.add(new Cube<TextureIdentifier>(min, max, sides));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makePartialCube(Vector3 min, Vector3 size, float minU, float minV, boolean clampCoords, Collection<CubeFacesData<TextureIdentifier>> directions) {
        Vector3 max = min.add(size);
        Vector3i s = new Vector3i((Vector3fc)size.asVec3f(), 4);
        float textureDepth = s.z();
        float maxFrontU = minU + (float)s.x();
        float maxFrontV = minV + (float)s.y();
        this.addCube(min, max, directions.stream().collect(Collectors.toMap(CubeFacesData::direction, cubeFacesData -> {
            TextureArea texCoords = switch (cubeFacesData.direction()) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11036 -> new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(minV - textureDepth, minV, clampCoords));
                case class_2350.field_11033 -> new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(maxFrontV, maxFrontV + textureDepth, clampCoords));
                case class_2350.field_11035 -> new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                case class_2350.field_11043 -> new TextureArea(new TextureSegment(maxFrontU, minU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                case class_2350.field_11039 -> new TextureArea(new TextureSegment(minU - textureDepth, minU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                case class_2350.field_11034 -> new TextureArea(new TextureSegment(maxFrontU, maxFrontU + textureDepth, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
            };
            return new FaceData(texCoords, cubeFacesData.rotation(), cubeFacesData.texture(), cubeFacesData.textureSize(), cubeFacesData.tintIndex());
        })));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSliceWithRim(Vector3 min, Vector3 size, int rimHeight, float uMin, float vMin, boolean shouldRenderWest, boolean shouldRenderEast, boolean isBothSided, FaceRotation mainTextureRotation, TextureIdentifier secondaryTexture, FaceRotation secondaryTextureRotation, TextureIdentifier mainTexture, int textureSize) {
        assert (size.y() > 2.0f);
        Predicate<class_2350> sideNotCulled = d -> !(d.equals((Object)class_2350.field_11039) && !shouldRenderWest || d.equals((Object)class_2350.field_11034) && !shouldRenderEast);
        this.makePartialCube(min, new Vector3(size.x(), rimHeight, size.z()), uMin, vMin + size.y() - (float)rimHeight, true, CubeFacesData.all(secondaryTexture, secondaryTextureRotation, textureSize, 1, d -> sideNotCulled.test((class_2350)d) && !d.equals((Object)class_2350.field_11036)));
        this.makePartialCube(min.withY(y -> Float.valueOf(y.floatValue() + size.y() - (float)rimHeight)), new Vector3(size.x(), rimHeight, size.z()), uMin, vMin, true, CubeFacesData.all(secondaryTexture, secondaryTextureRotation, textureSize, 1, d -> sideNotCulled.test((class_2350)d) && !d.equals((Object)class_2350.field_11033)));
        this.makePartialCube(min.withY(y -> Float.valueOf(y.floatValue() + (float)rimHeight)), new Vector3(size.x(), size.y() - (float)(2 * rimHeight), size.z()), uMin, vMin + (float)rimHeight, true, CubeFacesData.from(d -> d.equals((Object)class_2350.field_11035) || isBothSided ? Optional.of(Tuple.of(Tuple.of(mainTexture, mainTextureRotation), Tuple.of(textureSize, 0))) : (d.equals((Object)class_2350.field_11043) ? Optional.of(Tuple.of(Tuple.of(secondaryTexture, secondaryTextureRotation), Tuple.of(textureSize, 1))) : Optional.empty())));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSignOverlayAt(Vector3 center, float height, float widthLeft, float widthRight, float arrowWidth, boolean shouldAddLeftRim, TextureIdentifier mainTexture, int textureSize) {
        if (shouldAddLeftRim) {
            this.makePartialCube(center.add(-widthLeft - 1.0f - 0.1f, -height / 2.0f - 0.1f, -0.6f), new Vector3(1.0f, height + 0.2f - 1.0f, 1.2f), 1.0f, 2.0f, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, 0, dir -> dir != class_2350.field_11034));
        }
        this.makePartialCube(center.add(-widthLeft - 0.1f, -height / 2.0f - 0.1f - 1.0f, -0.6f), new Vector3(widthLeft + widthRight + 0.2f, height + 1.0f + 0.2f, 1.2f), 2.0f, 1.0f, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, 0, dir -> true));
        int stairsCount = Math.round(Math.min((height - 2.0f) / 2.0f, arrowWidth));
        int stairStep = Math.round((height - 2.0f) / (float)(2 * stairsCount));
        float stairsWidth = arrowWidth / (float)stairsCount;
        for (int i = 0; i < stairsCount; ++i) {
            this.makePartialCube(center.add(widthRight + stairsWidth * (float)i + 0.1f, -height / 2.0f - 0.1f + (float)(stairStep * i), -0.6f), new Vector3(stairsWidth, height + 1.0f + 0.2f - (float)(2 * (1 + stairStep * i)), 1.2f), 2.0f + widthLeft + widthRight + stairsWidth * (float)i, 2 + stairStep * i, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, 0, dir -> dir != class_2350.field_11039));
        }
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSignAt(Vector3 center, float height, float widthLeft, float widthRight, float arrowWidth, boolean shouldAddLeftRim, boolean isBothSided, TextureIdentifier secondaryTexture, TextureIdentifier mainTexture) {
        if (shouldAddLeftRim) {
            this.makePartialCube(center.add(-widthLeft - 1.0f, -height / 2.0f + 1.0f, -0.5f), new Vector3(1.0f, height - 2.0f, 1.0f), 15.0f, 8.0f - height / 2.0f + 1.0f, true, CubeFacesData.uniform(secondaryTexture, signTextureRotation, 16, 1, class_2350.field_11036, class_2350.field_11033, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035));
        }
        if (widthLeft + widthRight > 16.0f) {
            this.makeSliceWithRim(center.add(-widthLeft, -height / 2.0f, -0.5f), new Vector3(16.0f, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, true, false, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
            this.makeSliceWithRim(center.add(16.0f - widthLeft, -height / 2.0f, -0.5f), new Vector3(widthLeft + widthRight - 16.0f, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, false, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        } else {
            this.makeSliceWithRim(center.add(-widthLeft, -height / 2.0f, -0.5f), new Vector3(widthLeft + widthRight, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, true, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        }
        int stairsCount = Math.round(Math.min((height - 2.0f) / 2.0f, arrowWidth));
        int stairStep = Math.round((height - 2.0f) / (float)(2 * stairsCount));
        float stairsWidth = arrowWidth / (float)stairsCount;
        for (int i = 0; i < stairsCount - 1; ++i) {
            this.makeSliceWithRim(center.add(widthRight + stairsWidth * (float)i, -height / 2.0f + 1.0f + (float)(stairStep * i), -0.5f), new Vector3(stairsWidth, height - (float)(2 * (1 + stairStep * i)), 1.0f), stairStep, (widthLeft + widthRight + (float)(Math.round(stairsWidth) * i)) % 16.0f, 8.0f - height / 2.0f + 1.0f + (float)(stairStep * i), false, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        }
        int lastI = stairsCount - 1;
        this.makePartialCube(center.add(widthRight + stairsWidth * (float)lastI, -height / 2.0f + 1.0f + (float)(stairStep * lastI), -0.5f), new Vector3(stairsWidth, height - (float)(2 * (1 + stairStep * lastI)), 1.0f), (widthLeft + widthRight + (float)(Math.round(stairsWidth) * lastI)) % 16.0f, 8.0f - height / 2.0f + 1.0f + (float)(stairStep * lastI), true, CubeFacesData.uniform(secondaryTexture, signTextureRotation, 16, 1, class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeWideSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeWideSign(Vector3.ZERO, mainTexture, secondaryTexture);
    }

    public SignModelFactory<TextureIdentifier> makeWideSign(Vector3 offset, TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(offset.add(0.0f, 0.0f, 2.5f), 6.0f, 8.0f, 12.0f, 4.0f, true, false, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeShortSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(new Vector3(0.0f, 0.0f, 0.0f), 6.0f, -2.0f, 14.0f, 4.0f, false, true, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeLargeSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(new Vector3(0.0f, 0.0f, 2.5f), 12.0f, 8.0f, 10.0f, 3.0f, true, false, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeWideSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 2.5f), 6.0f, 8.0f, 12.0f, 4.0f, true, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makeShortSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 0.0f), 6.0f, -2.0f, 14.0f, 4.0f, false, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makeLargeSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 2.5f), 12.0f, 8.0f, 10.0f, 3.0f, true, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makePost(TextureIdentifier textureIdentifier) {
        return this.addCube(new Vector3(-2.0f, 0.0f, -2.0f), new Vector3(2.0f, 16.0f, 2.0f), Arrays.stream(class_2350.values()).collect(Collectors.toMap(d -> d, d -> {
            int offset = switch (d) {
                case class_2350.field_11034 -> 4;
                case class_2350.field_11043 -> 8;
                case class_2350.field_11039 -> 12;
                default -> 0;
            };
            TextureArea textureArea = switch (d) {
                case class_2350.field_11036 -> new TextureArea(new TextureSegment(0.0f, 4.0f, false), new TextureSegment(16.0f, 12.0f, false));
                case class_2350.field_11033 -> new TextureArea(new TextureSegment(0.0f, 4.0f, false), new TextureSegment(4.0f, 0.0f, false));
                default -> new TextureArea(new TextureSegment(offset, offset + 4, false), new TextureSegment(0.0f, 16.0f, false));
            };
            return new FaceData<Object>(textureArea, FaceRotation.Zero, textureIdentifier, 16, 0);
        })));
    }

    public SignModelFactory<TextureIdentifier> makeWaystoneInPost(TextureIdentifier textureIdentifier) {
        return this.addCube(new Vector3(-3.0f, 0.0f, -3.0f), new Vector3(3.0f, 6.0f, 3.0f), Arrays.stream(class_2350.values()).collect(Collectors.toMap(d -> d, d -> {
            TextureArea textureArea = new TextureArea(new TextureSegment(5.0f, 11.0f, false), new TextureSegment(5.0f, 11.0f, false));
            return new FaceData<Object>(textureArea, FaceRotation.Zero, textureIdentifier, 16, 0);
        })));
    }

    public SignModelFactory<TextureIdentifier> map(Function<Cube<TextureIdentifier>, Cube<TextureIdentifier>> func) {
        SignModelFactory<TextureIdentifier> ret = new SignModelFactory<TextureIdentifier>();
        ret.cubes.addAll(this.cubes.stream().map(func).collect(Collectors.toList()));
        return ret;
    }

    public <Result> Result build(Result builder, BiConsumer<Result, Cube<TextureIdentifier>> mkCube) {
        for (Cube<TextureIdentifier> cube : this.cubes) {
            mkCube.accept(builder, cube);
        }
        return builder;
    }

    public static class Builder {
        public static final BiConsumer<QuadModel[], Cube<Integer>> CUBE_LIST_BUILDER = (builders, cube) -> {
            for (Map.Entry face : cube.sides.entrySet()) {
                class_2350 dir = face.getKey();
                FaceData<Integer> faceData = face.getValue();
                Quad.Vertex[] vertices = Builder.verticesFor(cube, dir, faceData);
                builders[faceData.texture()].quads().add(new Quad(vertices, dir.method_23955()));
            }
        };
        public static final BiConsumer<QuadModel[], Cube<Integer>> CUBE_LIST_BUILDER_FLIPPED = (builders, cube) -> {
            for (Map.Entry face : cube.sides.entrySet()) {
                class_2350 dir = face.getKey();
                FaceData<Integer> faceData = face.getValue();
                Quad.Vertex[] vertices = Builder.verticesFor(cube, dir, faceData);
                if (dir.method_10166().equals((Object)class_2350.class_2351.field_11051)) {
                    dir = dir.method_10153();
                }
                for (int i = 0; i < vertices.length / 2; ++i) {
                    Quad.Vertex tmp = vertices[i];
                    vertices[i] = vertices[vertices.length - 1 - i];
                    vertices[vertices.length - 1 - i] = tmp;
                }
                for (Quad.Vertex vertex : vertices) {
                    vertex.pos().z = -vertex.pos().z;
                }
                builders[faceData.texture()].quads().add(new Quad(vertices, dir.method_23955()));
            }
        };

        private static Quad.Vertex[] verticesFor(Cube<Integer> cube, class_2350 dir, FaceData<Integer> faceData) {
            TextureArea textureArea = faceData.textureArea().rotate(faceData.rotation()).map(u -> Float.valueOf(u.floatValue() / 16.0f), v -> Float.valueOf(v.floatValue() / 16.0f));
            Vector3 from = cube.from.div(Float.valueOf(16.0f));
            Vector3 to = cube.to.div(Float.valueOf(16.0f));
            return Builder.verticesFor(dir, from, textureArea, to);
        }

        private static Quad.Vertex[] verticesFor(class_2350 dir, Vector3 from, TextureArea textureArea, Vector3 to) {
            Quad.Vertex[] vertexArray;
            switch (dir) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_11033: {
                    Quad.Vertex[] vertexArray2 = new Quad.Vertex[4];
                    vertexArray2[0] = new Quad.Vertex(new Vector3f(from.x(), from.y(), from.z()), textureArea.fromTo);
                    vertexArray2[1] = new Quad.Vertex(new Vector3f(to.x(), from.y(), from.z()), textureArea.to);
                    vertexArray2[2] = new Quad.Vertex(new Vector3f(to.x(), from.y(), to.z()), textureArea.toFrom);
                    vertexArray = vertexArray2;
                    vertexArray2[3] = new Quad.Vertex(new Vector3f(from.x(), from.y(), to.z()), textureArea.from);
                    break;
                }
                case field_11036: {
                    Quad.Vertex[] vertexArray3 = new Quad.Vertex[4];
                    vertexArray3[0] = new Quad.Vertex(new Vector3f(from.x(), to.y(), to.z()), textureArea.fromTo);
                    vertexArray3[1] = new Quad.Vertex(new Vector3f(to.x(), to.y(), to.z()), textureArea.to);
                    vertexArray3[2] = new Quad.Vertex(new Vector3f(to.x(), to.y(), from.z()), textureArea.toFrom);
                    vertexArray = vertexArray3;
                    vertexArray3[3] = new Quad.Vertex(new Vector3f(from.x(), to.y(), from.z()), textureArea.from);
                    break;
                }
                case field_11043: {
                    Quad.Vertex[] vertexArray4 = new Quad.Vertex[4];
                    vertexArray4[0] = new Quad.Vertex(new Vector3f(to.x(), from.y(), from.z()), textureArea.fromTo);
                    vertexArray4[1] = new Quad.Vertex(new Vector3f(from.x(), from.y(), from.z()), textureArea.to);
                    vertexArray4[2] = new Quad.Vertex(new Vector3f(from.x(), to.y(), from.z()), textureArea.toFrom);
                    vertexArray = vertexArray4;
                    vertexArray4[3] = new Quad.Vertex(new Vector3f(to.x(), to.y(), from.z()), textureArea.from);
                    break;
                }
                case field_11035: {
                    Quad.Vertex[] vertexArray5 = new Quad.Vertex[4];
                    vertexArray5[0] = new Quad.Vertex(new Vector3f(from.x(), from.y(), to.z()), textureArea.fromTo);
                    vertexArray5[1] = new Quad.Vertex(new Vector3f(to.x(), from.y(), to.z()), textureArea.to);
                    vertexArray5[2] = new Quad.Vertex(new Vector3f(to.x(), to.y(), to.z()), textureArea.toFrom);
                    vertexArray = vertexArray5;
                    vertexArray5[3] = new Quad.Vertex(new Vector3f(from.x(), to.y(), to.z()), textureArea.from);
                    break;
                }
                case field_11039: {
                    Quad.Vertex[] vertexArray6 = new Quad.Vertex[4];
                    vertexArray6[0] = new Quad.Vertex(new Vector3f(from.x(), from.y(), from.z()), textureArea.fromTo);
                    vertexArray6[1] = new Quad.Vertex(new Vector3f(from.x(), from.y(), to.z()), textureArea.to);
                    vertexArray6[2] = new Quad.Vertex(new Vector3f(from.x(), to.y(), to.z()), textureArea.toFrom);
                    vertexArray = vertexArray6;
                    vertexArray6[3] = new Quad.Vertex(new Vector3f(from.x(), to.y(), from.z()), textureArea.from);
                    break;
                }
                case field_11034: {
                    Quad.Vertex[] vertexArray7 = new Quad.Vertex[4];
                    vertexArray7[0] = new Quad.Vertex(new Vector3f(to.x(), from.y(), to.z()), textureArea.fromTo);
                    vertexArray7[1] = new Quad.Vertex(new Vector3f(to.x(), from.y(), from.z()), textureArea.to);
                    vertexArray7[2] = new Quad.Vertex(new Vector3f(to.x(), to.y(), from.z()), textureArea.toFrom);
                    vertexArray = vertexArray7;
                    vertexArray7[3] = new Quad.Vertex(new Vector3f(to.x(), to.y(), to.z()), textureArea.from);
                }
            }
            return vertexArray;
        }
    }
}

