/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_10515;
import net.minecraft.class_11659;
import net.minecraft.class_11701;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PostItemRenderer
implements class_10515<PostData> {
    private final PostBlock.ModelType fallbackType;
    private final class_11701 materials;

    public PostItemRenderer(PostBlock.ModelType fallbackType, class_11701 materials) {
        this.fallbackType = fallbackType;
        this.materials = materials;
    }

    public void method_72175(Set<Vector3f> set) {
        set.add(new Vector3f(-1.0f, 0.0f, -1.0f));
        set.add(new Vector3f(-1.0f, 0.0f, 1.0f));
        set.add(new Vector3f(1.0f, 0.0f, 1.0f));
        set.add(new Vector3f(1.0f, 0.0f, -1.0f));
    }

    public PostData extractArgument(class_1799 itemStack) {
        PostData data = (PostData)itemStack.method_58694(PostData.TYPE);
        if (data == null) {
            HashMap<UUID, BlockPartInstance> parts = new HashMap<UUID, BlockPartInstance>();
            parts.put(UUID.randomUUID(), new BlockPartInstance(new PostBlockPart(this.fallbackType.postTexture), Vector3.ZERO));
            parts.put(UUID.randomUUID(), new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.Literal(Angle.fromDegrees(180.0f)), new NameProvider.Literal(""), true, this.fallbackType.mainTexture, this.fallbackType.secondaryTexture, Optional.empty(), -1, Optional.empty(), Optional.empty(), this.fallbackType, false, false), new Vector3(0.0f, 0.75f, 0.0f)));
            data = new PostData(parts);
        }
        return data;
    }

    public void submit(PostData data, class_811 displayContext, class_4587 poseStack, class_11659 nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        ArrayList<Object> parts;
        if (data != null) {
            parts = new ArrayList<BlockPartInstance>(data.parts().values());
        } else {
            parts = new ArrayList<BlockPartInstance>();
            parts.add(new BlockPartInstance(new PostBlockPart(this.fallbackType.postTexture), Vector3.ZERO));
            parts.add(new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.Literal(Angle.fromDegrees(180.0f)), new NameProvider.Literal(""), true, this.fallbackType.mainTexture, this.fallbackType.secondaryTexture, Optional.empty(), -1, Optional.empty(), Optional.empty(), this.fallbackType, false, false), new Vector3(0.0f, 0.75f, 0.0f)));
        }
        RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
            poseStack.method_22904(0.5, 0.0, 0.5);
            switch (displayContext) {
                case field_4317: {
                    poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                    poseStack.method_22905(0.9f, 0.9f, 0.9f);
                    break;
                }
                case field_4322: 
                case field_4321: 
                case field_4320: {
                    poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(270.0f));
                    break;
                }
                case field_4323: {
                    poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                    break;
                }
                case field_4319: {
                    poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                }
            }
            for (BlockPartInstance now : parts) {
                RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
                    poseStack.method_46416(now.offset().x(), now.offset().y(), now.offset().z());
                    BlockPartRenderer.renderDynamic(now.blockPart(), (class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_24515(), poseStack, nodeCollector, this.materials, packedLight, packedOverlay, displayContext == class_811.field_4317 ? t -> class_1921.method_23577() : class_1921::method_23576, null);
                });
            }
        });
    }

    public record Unbaked(PostBlock.ModelType fallbackType) implements class_10515.class_10516
    {
        public static final class_2960 NAME = class_2960.method_60655((String)"signpost", (String)"post_item");
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostBlock.ModelType.CODEC.fieldOf("fallback").forGetter(Unbaked::fallbackType)).apply((Applicative)instance, Unbaked::new));

        public class_10515<?> method_65698(class_10515.class_11695 context) {
            return new PostItemRenderer(this.fallbackType, context.comp_4551());
        }

        public MapCodec<Unbaked> method_65696() {
            return MAP_CODEC;
        }
    }
}

