/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.mixin.LevelRendererAccessor;
import gollorum.signpost.utils.BlockPartInstance;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class PostRenderer
implements class_827<PostTile, PostRenderState> {
    private static final double randomOffset = 0.001;
    private final class_11701 materials;

    public PostRenderer(class_5614.class_5615 ctx) {
        this.materials = ctx.comp_4541();
    }

    public PostRenderState createRenderState() {
        return new PostRenderState();
    }

    public void extractRenderState(PostTile blockEntity, PostRenderState renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        renderState.tile = blockEntity;
    }

    public void submit(PostRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        long randomSeed = renderState.tile.hashCode();
        class_5819 random = class_5819.method_43049((long)randomSeed);
        SortedSet destructionProgresses = (SortedSet)((LevelRendererAccessor)class_310.method_1551().field_1769).getDestructionProgress().get(renderState.field_62673.method_10063());
        Set partsBeingBroken = destructionProgresses == null ? null : destructionProgresses.stream().map(progress -> Optional.ofNullable(renderState.tile.method_10997().method_8469(progress.method_34868())).flatMap(renderState.tile::trace).map(res -> res.part)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        boolean shouldUseOriginalBuffer = partsBeingBroken == null || partsBeingBroken.isEmpty() || partsBeingBroken.stream().anyMatch(i -> i.blockPart() instanceof PostBlockPart);
        RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
            poseStack.method_22904(0.5, 0.0, 0.5);
            for (BlockPartInstance now : renderState.tile.getParts()) {
                RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
                    poseStack.method_22904((double)now.offset().x() + 0.001 * random.method_43058(), (double)now.offset().y() + 0.001 * random.method_43058(), (double)now.offset().z() + 0.001 * random.method_43058());
                    BlockPartRenderer.renderDynamic(now.blockPart(), renderState.tile.method_10997(), renderState.field_62673, poseStack, submitNodeCollector, this.materials, renderState.field_62676, class_4608.field_21444, t -> class_1921.method_23581(), (class_11683.class_11792)(shouldUseOriginalBuffer || partsBeingBroken.contains(now) ? renderState.field_62677 : null));
                });
            }
        });
    }

    public static class PostRenderState
    extends class_11954 {
        PostTile tile;
    }
}

