/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.models.modelGeneration.Quad;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.GuiFakeCollector;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1088;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderingUtil {
    public static void render(class_4587 blockToView, TexturedModel model, class_11659 nodeCollector, class_11701 materials, int combinedLights, int combinedOverlay, Function<class_2960, class_1921> renderTypeFactory, class_11683.class_11792 crumblingOverlay) {
        class_1921 renderType = model.texture().method_24146(renderTypeFactory);
        class_11659.class_11660 doRender = (pose, vertexConsumer) -> {
            RenderingUtil.render(pose, model.model(), materials.method_73030(model.texture()).method_24108(vertexConsumer), combinedLights, combinedOverlay, model.tint(), 0.0f);
            if (crumblingOverlay != null && renderType.method_23037()) {
                class_1921 crumblingTenderType = (class_1921)class_1088.field_21772.get(crumblingOverlay.comp_4656());
                class_4583 vertexconsumer2 = new class_4583(class_310.method_1551().method_22940().method_23001().method_73477(crumblingTenderType), crumblingOverlay.comp_4657(), 1.0f);
                RenderingUtil.render(pose, model.model(), materials.method_73030(model.texture()).method_24108((class_4588)vertexconsumer2), combinedLights, combinedOverlay, model.tint(), 0.001f);
            }
        };
        if (nodeCollector instanceof GuiFakeCollector) {
            GuiFakeCollector gfc = (GuiFakeCollector)nodeCollector;
            gfc.submitCustomGeometry(blockToView, renderType, doRender, model.texture().method_24144());
        } else {
            nodeCollector.method_73483(blockToView, renderType, doRender);
        }
    }

    public static void render(class_4587.class_4665 pose, QuadModel model, class_4588 buffer, int combinedLights, int combinedOverlay, int color, float offset) {
        Matrix4f matrix = pose.method_23761();
        Vector3f bufferVector = new Vector3f();
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        for (Quad quad : model.quads()) {
            pose.method_56821((Vector3fc)quad.normal(), bufferVector);
            float normalX = bufferVector.x;
            float normalY = bufferVector.y;
            float normalZ = bufferVector.z;
            for (Quad.Vertex vertex : quad.vertices()) {
                matrix.transformPosition((Vector3fc)vertex.pos(), bufferVector);
                buffer.method_23919(bufferVector.x() + offset * normalX, bufferVector.y() + offset * normalY, bufferVector.z() + offset * normalZ, color, vertex.u(), vertex.v(), combinedOverlay, combinedLights, normalX, normalY, normalZ);
            }
        }
    }

    public static void drawString(class_332 graphics, class_327 fontRenderer, String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int color, int maxWidth, boolean dropShadow) {
        int textWidth = fontRenderer.method_1727(text);
        float scale = Math.min(1.0f, (float)maxWidth / (float)textWidth);
        graphics.method_51448().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = graphics.method_51448();
        float f = (float)Rect.xCoordinateFor(point.x, maxWidth, xAlignment) + (float)maxWidth * 0.5f;
        int n = point.y;
        Objects.requireNonNull(fontRenderer);
        float f2 = Rect.yCoordinateFor(n, 9, yAlignment);
        Objects.requireNonNull(fontRenderer);
        matrix3x2fStack.translation(f, f2 + 9.0f * 0.5f);
        if (scale < 1.0f) {
            graphics.method_51448().scale(scale, scale);
        }
        int n2 = (maxWidth - Math.min(maxWidth, textWidth)) / 2;
        Objects.requireNonNull(fontRenderer);
        graphics.method_51433(fontRenderer, text, n2, -9 / 2, color, dropShadow);
        graphics.method_51448().popMatrix();
    }

    public static void wrapInMatrixEntry(class_4587 matrixStack, Runnable thenDo) {
        matrixStack.method_22903();
        thenDo.run();
        matrixStack.method_22909();
    }
}

