/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TileEntityUtils {
    public static <T extends class_2586> void delayUntilTileEntityExists(class_1936 world, class_2338 pos, class_2591<T> c, Consumer<T> action, int timeout, Optional<Runnable> onTimeOut) {
        IDelay.untilIsPresent(() -> world.method_35230(pos, c), action, timeout, world.method_8608(), onTimeOut);
    }

    public static <T extends class_2586> Optional<T> findTileEntity(class_2960 dimensionKeyLocation, boolean isRemote, class_2338 blockPos, class_2591<T> c) {
        return TileEntityUtils.findWorld(dimensionKeyLocation, isRemote).flatMap(world -> world.method_35230(blockPos, c));
    }

    public static Optional<class_1937> findWorld(class_2960 dimensionKeyLocation, boolean isClient) {
        return isClient ? (class_310.method_1551().field_1687.method_27983().method_29177().equals((Object)dimensionKeyLocation) ? Optional.of(class_310.method_1551().field_1687) : Optional.empty()) : (Signpost.getServerType().isServer ? Optional.ofNullable(Signpost.getServerInstance().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionKeyLocation))) : Optional.empty());
    }

    public static Optional<class_1937> toWorld(Either<class_1937, class_2960> either, boolean onClient) {
        return either.match(Optional::of, right -> TileEntityUtils.findWorld(right, onClient));
    }

    public static <T> Optional<T> findTileEntityAt(WorldLocation location, Class<T> c, boolean onClient) {
        return TileEntityUtils.toWorld(location.world(), onClient).map(w -> w.method_8321(location.blockPos())).flatMap(tile -> c.isAssignableFrom(tile.getClass()) ? Optional.of(tile) : Optional.empty());
    }

    public static <T extends class_2586> Optional<T> findTileEntityAt(WorldLocation location, class_2591<T> c, boolean onClient) {
        return TileEntityUtils.toWorld(location.world(), onClient).flatMap(w -> w.method_35230(location.blockPos(), c));
    }

    public static <T> void delayUntilTileEntityExistsAt(WorldLocation location, Class<T> c, Consumer<T> action, int timeout, boolean onClient, Optional<Runnable> onTimeOut) {
        IDelay.untilIsPresent(() -> TileEntityUtils.findTileEntityAt(location, c, onClient), action, timeout, onClient, onTimeOut);
    }

    public static <T extends class_2586> void delayUntilTileEntityExistsAt(WorldLocation location, class_2591<T> c, Consumer<T> action, int timeout, boolean onClient, Optional<Runnable> onTimeOut) {
        IDelay.untilIsPresent(() -> TileEntityUtils.findTileEntityAt(location, c, onClient), action, timeout, onClient, onTimeOut);
    }

    public static <T extends class_2586> Optional<T> findTileEntityClient(class_2960 dimensionKeyLocation, class_2338 pos, class_2591<T> c) {
        return class_310.method_1551().field_1687.method_27983().method_29177().equals((Object)dimensionKeyLocation) ? class_310.method_1551().field_1687.method_35230(pos, c) : Optional.empty();
    }
}

