/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5138;
import net.minecraft.class_5188;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9822;
import org.jetbrains.annotations.NotNull;

public class SignpostJigsawPiece
extends class_5188 {
    private static Map<class_2338, Integer> signpostCountForVillage;
    public static final MapCodec<SignpostJigsawPiece> codec;
    public final boolean isZombie;

    public static void reset() {
        signpostCountForVillage = new HashMap<class_2338, Integer>();
    }

    private static RecordCodecBuilder<SignpostJigsawPiece, Boolean> isZombieCodec() {
        return Codec.BOOL.fieldOf("isZombie").forGetter(o -> o.isZombie);
    }

    public SignpostJigsawPiece(class_2960 location, class_6880<class_5497> structureProcessorListSupplier, class_3785.class_3786 placementBehaviour, Optional<class_9822> liquidSettings, boolean isZombie) {
        this((Either<class_2960, class_3499>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour, liquidSettings, isZombie);
    }

    public SignpostJigsawPiece(Either<class_2960, class_3499> template, class_6880<class_5497> structureProcessorListSupplier, class_3785.class_3786 placementBehaviour, Optional<class_9822> liquidSettings, boolean isZombie) {
        super(template, structureProcessorListSupplier, placementBehaviour, liquidSettings);
        this.isZombie = isZombie;
    }

    public boolean method_16626(class_3485 templateManager, class_5281 seedReader, class_5138 structureManager, class_2794 chunkGenerator, class_2338 pieceLocation, class_2338 villageLocation, class_2470 rotation, class_3341 boundingBox, class_5819 random, class_9822 liquidSettings, boolean keepJigsaws) {
        class_3492 placementSettings;
        if (!IConfig.IServer.getInstance().worldGen().isVillageGenerationEnabled()) {
            return false;
        }
        if (signpostCountForVillage.getOrDefault(villageLocation, 0) >= IConfig.IServer.getInstance().worldGen().maxSignpostsPerVillage()) {
            return false;
        }
        class_3499 template = (class_3499)this.field_24015.map(arg_0 -> ((class_3485)templateManager).method_15091(arg_0), Function.identity());
        if (template.method_15172((class_5425)seedReader, pieceLocation, villageLocation, placementSettings = this.method_16616(rotation, boundingBox, liquidSettings, keepJigsaws), random, 18)) {
            signpostCountForVillage.put(villageLocation, signpostCountForVillage.getOrDefault(villageLocation, 0) + 1);
            return true;
        }
        return false;
    }

    @NotNull
    public class_3816<?> method_16757() {
        return JigsawDeserializers.signpost;
    }

    @NotNull
    public String toString() {
        return "SingleSignpost[" + String.valueOf(this.field_24015) + "]";
    }

    static {
        codec = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)SignpostJigsawPiece.method_28882(), (App)SignpostJigsawPiece.method_28880(), (App)SignpostJigsawPiece.method_28883(), (App)SignpostJigsawPiece.method_61013(), SignpostJigsawPiece.isZombieCodec()).apply((Applicative)codecBuilder, SignpostJigsawPiece::new));
    }
}

