/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.VillageGenUtils;
import gollorum.signpost.platform.Services;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_6796;
import net.minecraft.class_6819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class VillageSignpost {
    private static final float smallSignRatio = 0.5f;
    private static Map<class_2338, List<WaystoneHandle.Vanilla>> waystonesTargetedByVillage;

    public static void reset() {
        waystonesTargetedByVillage = new HashMap<class_2338, List<WaystoneHandle.Vanilla>>();
    }

    public static boolean populate(PostTile tile, SignBlockPart<?> generatorPart, UUID generatorPartId, float height, class_3218 level) {
        class_2338 pieceLocation = tile.method_11016();
        class_2338 villageLocation = VillageGenUtils.getVillageLocationFor(level, pieceLocation, 512);
        Random random = new Random(level.method_8412() ^ pieceLocation.method_10063());
        Set<WaystoneHandle> blockedTargets = tile.getParts().stream().flatMap(p -> {
            SignBlockPart sbb;
            BlockPart patt0$temp = p.blockPart();
            return patt0$temp instanceof SignBlockPart && !(sbb = (SignBlockPart)patt0$temp).isMarkedForGeneration() ? sbb.getDestination().stream() : Stream.empty();
        }).collect(Collectors.toSet());
        Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets = VillageSignpost.fetchPossibleTargets(pieceLocation, villageLocation, level.method_27983().method_29177(), random, blockedTargets);
        if (possibleTargets.isEmpty()) {
            return false;
        }
        Collection<WaystoneHandle.Vanilla> freshlyUsedWaystones = VillageSignpost.populateSignPostGeneration(tile, generatorPart, height, ((class_2350)tile.method_11010().method_11654(PostBlock.Facing)).method_10153(), pieceLocation, level, random, possibleTargets);
        if (freshlyUsedWaystones.isEmpty()) {
            return false;
        }
        waystonesTargetedByVillage.computeIfAbsent(villageLocation, k -> new ArrayList()).addAll(freshlyUsedWaystones);
        tile.removePart(generatorPartId);
        tile.method_5431();
        return true;
    }

    private static Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> fetchPossibleTargets(class_2338 pieceLocation, class_2338 villageLocation, class_2960 dimension, Random random, Set<WaystoneHandle> blockedTargets) {
        return VillageSignpost.allWaystoneTargets(villageLocation, dimension).map(e -> new Tuple<Tuple, Float>((Tuple)e, Float.valueOf((float)Math.sqrt(((class_2338)e._1()).method_10262((class_2382)pieceLocation)) * (0.5f + random.nextFloat())))).sorted((e1, e2) -> Float.compare(((Float)e1._2()).floatValue(), ((Float)e2._2()).floatValue())).map(Tuple::getLeft).filter(e -> !blockedTargets.contains(e._2())).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Tuple<class_2338, WaystoneHandle.Vanilla>> allWaystoneTargets(class_2338 villageLocation, class_2960 dimension) {
        Stream villageWaystones = VillageSignpost.villageWaystonesExceptSelf(villageLocation, dimension);
        return (IConfig.IServer.getInstance().worldGen().villagesOnlyTargetVillages() ? villageWaystones : Streams.concat((Stream[])new Stream[]{villageWaystones, VillageSignpost.nonVillageWaystones(dimension)})).filter(e -> !waystonesTargetedByVillage.containsKey(villageLocation) || !waystonesTargetedByVillage.get(villageLocation).contains(e._2()));
    }

    private static Stream<Tuple<class_2338, WaystoneHandle.Vanilla>> villageWaystonesExceptSelf(class_2338 villageLocation, class_2960 dimension) {
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        return lib.getVillageWaystones().getAllEntries(lib, dimension).stream().filter(e -> !((class_2338)e.getKey()).equals((Object)villageLocation)).map(Tuple::from);
    }

    private static Stream<Tuple<class_2338, WaystoneHandle.Vanilla>> nonVillageWaystones(class_2960 dimension) {
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        return lib.getAllWaystoneInfo().stream().map(info -> new Tuple<class_2338, WaystoneHandle.Vanilla>(info.locationData().block().blockPos(), info.handle())).filter(t -> lib.getVillageWaystones().getAllEntries(lib, dimension).stream().noneMatch(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(t._2())));
    }

    private static Collection<WaystoneHandle.Vanilla> populateSignPostGeneration(PostTile tile, SignBlockPart<?> generatorPart, float height, class_2350 facing, class_2338 pieceLocation, class_3218 level, Random random, Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets) {
        return VillageSignpost.makeSign(tile, generatorPart, random, facing, level, pieceLocation, possibleTargets, height);
    }

    public static Collection<WaystoneHandle.Vanilla> makeSign(PostTile tile, SignBlockPart<?> generatorPart, Random random, class_2350 facing, class_3218 world, class_2338 tilePos, Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        if (possibleTargets.isEmpty()) {
            return Collections.emptySet();
        }
        return random.nextFloat() < 0.5f ? VillageSignpost.makeShortSigns(tile, generatorPart, facing, world, tilePos, possibleTargets, y) : VillageSignpost.makeWideSign(tile, generatorPart, facing, world, tilePos, possibleTargets, y);
    }

    private static Collection<WaystoneHandle.Vanilla> makeWideSign(PostTile tile, SignBlockPart<?> generatorPart, class_2350 facing, class_3218 world, class_2338 tilePos, Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<class_2338, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return Collections.emptySet();
        }
        Tuple<class_2338, WaystoneHandle.Vanilla> target = nextTargetOption.get()._1();
        WaystoneData targetData = nextTargetOption.get()._2();
        Angle rotation = SignBlockPart.pointingAt(tilePos, target._1());
        if (tile.getParts().stream().anyMatch(instance -> {
            SignBlockPart s;
            BlockPart patt0$temp;
            return !(instance.blockPart() instanceof PostBlockPart) && (!((patt0$temp = instance.blockPart()) instanceof SignBlockPart) || !(s = (SignBlockPart)patt0$temp).isMarkedForGeneration()) && VillageSignpost.isNearly(instance.offset().y(), y);
        })) {
            possibleTargets.add(target);
            return Collections.emptySet();
        }
        tile.addPart(new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.WaystoneTarget(rotation), new NameProvider.WaystoneTarget(targetData.name()), VillageSignpost.shouldFlip(facing, rotation), generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), VillageSignpost.overlayFor(world, tilePos).or(generatorPart::getOverlay), generatorPart.getColor(), Optional.of((WaystoneHandle)target._2()), Optional.empty(), tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), class_1799.field_8037, PlayerHandle.Invalid, false);
        return Collections.singleton(target._2());
    }

    private static boolean isNearly(float a, float b) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    private static Collection<WaystoneHandle.Vanilla> makeShortSigns(PostTile tile, SignBlockPart<?> generatorPart, class_2350 facing, class_3218 world, class_2338 tilePos, Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<class_2338, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return Collections.emptySet();
        }
        Tuple<class_2338, WaystoneHandle.Vanilla> target = nextTargetOption.get()._1();
        WaystoneData targetData = nextTargetOption.get()._2();
        Angle rotation = SignBlockPart.pointingAt(tilePos, target._1());
        boolean shouldFlip = VillageSignpost.shouldFlip(facing, rotation);
        Optional<Overlay> overlay = VillageSignpost.overlayFor(world, tilePos).or(generatorPart::getOverlay);
        tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(new AngleProvider.WaystoneTarget(rotation), new NameProvider.WaystoneTarget(targetData.name()), shouldFlip, generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), overlay, generatorPart.getColor(), Optional.of((WaystoneHandle)target._2()), Optional.empty(), tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), class_1799.field_8037, PlayerHandle.Invalid, false);
        Optional<Tuple<Tuple<class_2338, WaystoneHandle.Vanilla>, WaystoneData>> secondNextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (secondNextTargetOption.isEmpty()) {
            return Collections.singleton(target._2());
        }
        Tuple<class_2338, WaystoneHandle.Vanilla> secondTarget = secondNextTargetOption.get()._1();
        ArrayList<Tuple<class_2338, WaystoneHandle.Vanilla>> skippedTargets = new ArrayList<Tuple<class_2338, WaystoneHandle.Vanilla>>();
        while (secondTarget != null) {
            WaystoneData secondTargetData = secondNextTargetOption.get()._2();
            Angle secondRotation = SignBlockPart.pointingAt(tilePos, secondTarget._1());
            boolean shouldSecondFlip = VillageSignpost.shouldFlip(facing, secondRotation);
            if (shouldSecondFlip == shouldFlip) {
                skippedTargets.add(secondTarget);
                secondNextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
                secondTarget = secondNextTargetOption.isEmpty() ? null : secondNextTargetOption.get()._1();
                continue;
            }
            WaystoneHandle.Vanilla secondTargetHandle = secondTarget._2();
            tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(new AngleProvider.WaystoneTarget(secondRotation), new NameProvider.WaystoneTarget(secondTargetData.name()), shouldSecondFlip, generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), overlay, generatorPart.getColor(), Optional.of(secondTargetHandle), Optional.empty(), tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), class_1799.field_8037, PlayerHandle.Invalid, false);
            break;
        }
        skippedTargets.addAll(possibleTargets);
        possibleTargets.clear();
        possibleTargets.addAll(skippedTargets);
        return secondTarget == null ? Collections.singleton(target._2()) : ImmutableList.of((Object)target._2(), (Object)secondTarget._2());
    }

    private static Optional<Tuple<Tuple<class_2338, WaystoneHandle.Vanilla>, WaystoneData>> fetchNextTarget(Queue<Tuple<class_2338, WaystoneHandle.Vanilla>> possibleTargets) {
        Tuple<class_2338, WaystoneHandle.Vanilla> target = null;
        WaystoneData targetData = null;
        while (target == null && !possibleTargets.isEmpty()) {
            target = possibleTargets.poll();
            if (target == null) continue;
            if (!WaystoneLibrary.getInstance().contains(target._2())) {
                target = null;
                continue;
            }
            Optional<WaystoneData> dataOptional = WaystoneLibrary.getInstance().getData(target._2());
            if (dataOptional.isPresent()) {
                targetData = dataOptional.get();
                continue;
            }
            target = null;
        }
        return target == null ? Optional.empty() : Optional.of(Tuple.of(target, targetData));
    }

    private static boolean shouldFlip(class_2350 facing, Angle signRotation) {
        float degrees = signRotation.add(Angle.fromDegrees(facing.method_10144())).normalized().degrees();
        return degrees > -90.0f && degrees < 90.0f;
    }

    private static Optional<Overlay> overlayFor(class_3218 world, class_2338 pos) {
        boolean isMushroomMeadow;
        class_6880 biomeHolder = world.method_23753(pos);
        class_1959 biome = (class_1959)biomeHolder.comp_349();
        Optional featureRegistry = world.method_8503().method_30611().method_46759(class_7924.field_41245);
        Optional jungleTrees = featureRegistry.flatMap(r -> r.method_46746(class_6819.field_36158));
        Optional mush = featureRegistry.flatMap(r -> r.method_46746(class_6819.field_36160));
        boolean isJungle = jungleTrees.isPresent() && biome.method_30970().method_38105((class_6796)((class_6880.class_6883)jungleTrees.get()).comp_349());
        boolean bl = isMushroomMeadow = mush.isPresent() && biome.method_30970().method_38105((class_6796)((class_6880.class_6883)mush.get()).comp_349());
        if (isMushroomMeadow) {
            return Optional.of(Overlay.Mycelium);
        }
        if (biome.method_8696((class_4538)world, pos) || biome.method_48162(pos, world.method_8615()) == class_1959.class_1963.field_9383) {
            return Optional.of(Overlay.Snow);
        }
        if (isJungle) {
            return Optional.of(Overlay.Vine);
        }
        if (Services.BIOME_ACCESSOR.downfallIn(biome) > 0.85f) {
            return Optional.of(Overlay.Gras);
        }
        return Optional.empty();
    }
}

