/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.platform.Services;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class VillageWaystone {
    public static final Codec<VillageWaystone> CODEC = Entry.CODEC.listOf().xmap(VillageWaystone::new, villageWaystone -> villageWaystone.allEntries);
    private final Map<class_2338, WaystoneHandle.Vanilla> generatedWaystones = new HashMap<class_2338, WaystoneHandle.Vanilla>();
    private final Map<ChunkEntryKey, WaystoneHandle.Vanilla> generatedWaystonesByChunk = new HashMap<ChunkEntryKey, WaystoneHandle.Vanilla>();
    private final List<Entry> allEntries;

    public static VillageWaystone getInstance() {
        return WaystoneLibrary.getInstance().data.villageWaystones;
    }

    public VillageWaystone() {
        this.allEntries = new ArrayList<Entry>();
    }

    private VillageWaystone(List<Entry> generatedWaystones) {
        this.allEntries = new ArrayList<Entry>(generatedWaystones);
        for (Entry entry : generatedWaystones) {
            this.generatedWaystones.put(entry.referencePos, entry.handle);
            this.generatedWaystonesByChunk.put(entry.chunkEntryKey, entry.handle);
        }
    }

    public boolean doesWaystoneExistIn(class_2338 villageLocation) {
        return this.generatedWaystones.containsKey(villageLocation);
    }

    public void register(WaystoneLibrary waystoneLibrary, String name, class_2338 referencePos, class_3218 world, class_2338 blockPos) {
        waystoneLibrary.getHandleByName(name).ifPresent(handle -> {
            ChunkEntryKey key = new ChunkEntryKey(new class_1923(blockPos), world.method_27983().method_29177());
            this.generatedWaystones.put(referencePos, (WaystoneHandle.Vanilla)handle);
            this.generatedWaystonesByChunk.put(key, (WaystoneHandle.Vanilla)handle);
            this.allEntries.add(new Entry((WaystoneHandle.Vanilla)handle, referencePos, key));
            waystoneLibrary.markDirty();
            Services.WAYSTONE_DISCOVERY_EVENT_LISTENER.registerNew((WaystoneHandle.Vanilla)handle, world, blockPos);
        });
    }

    public static void reset() {
        Services.WAYSTONE_DISCOVERY_EVENT_LISTENER.initialize();
    }

    public Set<Map.Entry<class_2338, WaystoneHandle.Vanilla>> getAllEntries(WaystoneLibrary waystoneLibrary, class_2960 dimension) {
        List<Entry> toRemove = this.allEntries.stream().filter(e -> waystoneLibrary.getData(e.handle).isEmpty()).toList();
        for (Entry entry : toRemove) {
            this.generatedWaystones.remove(entry.referencePos);
            this.generatedWaystonesByChunk.remove(entry.chunkEntryKey);
            this.allEntries.remove(entry);
        }
        if (!toRemove.isEmpty()) {
            waystoneLibrary.markDirty();
        }
        return this.generatedWaystones.entrySet().stream().filter(e -> this.dimensionOf((WaystoneHandle.Vanilla)e.getValue()).map(d -> d.equals((Object)dimension)).orElse(true)).collect(Collectors.toSet());
    }

    private Optional<class_2960> dimensionOf(WaystoneHandle.Vanilla handle) {
        return this.generatedWaystonesByChunk.entrySet().stream().filter(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(handle)).findFirst().map(e -> ((ChunkEntryKey)e.getKey()).dimensionKey);
    }

    public Map<ChunkEntryKey, WaystoneHandle.Vanilla> getAllEntriesByChunk(WaystoneLibrary waystoneLibrary, boolean validateExistence) {
        if (validateExistence) {
            List<Entry> toRemove = this.allEntries.stream().filter(e -> waystoneLibrary.getData(e.handle).isEmpty()).toList();
            for (Entry entry : toRemove) {
                this.generatedWaystones.remove(entry.referencePos);
                this.generatedWaystonesByChunk.remove(entry.chunkEntryKey);
                this.allEntries.remove(entry);
            }
            if (!toRemove.isEmpty()) {
                waystoneLibrary.markDirty();
            }
        }
        return this.generatedWaystonesByChunk;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> IConfig.IServer.getInstance().worldGen().allowedVillageWaystones().contains(v.name)).map(ModelWaystone.Variant::getBlock).collect(Collectors.toList());
    }

    private record Entry(WaystoneHandle.Vanilla handle, class_2338 referencePos, ChunkEntryKey chunkEntryKey) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)WaystoneHandle.Vanilla.CODEC.fieldOf("waystone").forGetter(Entry::handle), (App)BlockPosSerializer.CODEC.fieldOf("refPos").forGetter(Entry::referencePos), (App)ChunkEntryKey.CODEC.fieldOf("chunkEntryKey").forGetter(Entry::chunkEntryKey)).apply((Applicative)i, Entry::new));
    }

    public record ChunkEntryKey(class_1923 chunkPos, class_2960 dimensionKey) {
        public static final Codec<ChunkEntryKey> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("x").forGetter(c -> c.chunkPos.field_9181), (App)Codec.INT.fieldOf("z").forGetter(c -> c.chunkPos.field_9180), (App)class_2960.field_25139.fieldOf("ResourceLocation").forGetter(ChunkEntryKey::dimensionKey)).apply((Applicative)i, (x, z, recloc) -> new ChunkEntryKey(new class_1923(x.intValue(), z.intValue()), (class_2960)recloc)));

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkEntryKey that = (ChunkEntryKey)o;
            return this.chunkPos.equals((Object)that.chunkPos) && this.dimensionKey.equals((Object)that.dimensionKey);
        }
    }
}

