/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5138;
import net.minecraft.class_5188;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9822;
import org.jetbrains.annotations.NotNull;

public class WaystoneJigsawPiece
extends class_5188 {
    private static Set<class_2338> generatedPieces;
    public static final MapCodec<WaystoneJigsawPiece> codec;

    public static void reset() {
        generatedPieces = new HashSet<class_2338>();
    }

    public WaystoneJigsawPiece(class_2960 location, class_6880<class_5497> structureProcessorListSupplier, class_3785.class_3786 placementBehaviour, Optional<class_9822> liquidSettings) {
        this((Either<class_2960, class_3499>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour, liquidSettings);
    }

    public WaystoneJigsawPiece(Either<class_2960, class_3499> template, class_6880<class_5497> structureProcessorListSupplier, class_3785.class_3786 placementBehaviour, Optional<class_9822> liquidSettings) {
        super(template, structureProcessorListSupplier, placementBehaviour, liquidSettings);
    }

    public boolean method_16626(class_3485 templateManager, class_5281 seedReader, class_5138 structureManager, class_2794 chunkGenerator, class_2338 pieceLocation, class_2338 villageLocation, class_2470 rotation, class_3341 boundingBox, class_5819 random, class_9822 liquidSettings, boolean keepJigsaws) {
        if (!IConfig.IServer.getInstance().worldGen().isVillageGenerationEnabled()) {
            return false;
        }
        if (generatedPieces.contains(villageLocation) || VillageWaystone.getInstance().doesWaystoneExistIn(villageLocation)) {
            return false;
        }
        class_3492 placementSettings = this.method_16616(rotation, boundingBox, liquidSettings, keepJigsaws);
        class_3499 template = (class_3499)this.field_24015.map(arg_0 -> ((class_3485)templateManager).method_15091(arg_0), Function.identity());
        if (template.method_15172((class_5425)seedReader, pieceLocation, villageLocation, placementSettings, random, 18)) {
            generatedPieces.add(villageLocation);
            return true;
        }
        return false;
    }

    @NotNull
    public class_3816<?> method_16757() {
        return JigsawDeserializers.waystone;
    }

    @NotNull
    public String toString() {
        return "SingleSignpostWaystone[" + String.valueOf(this.field_24015) + "]";
    }

    static {
        codec = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)WaystoneJigsawPiece.method_28882(), (App)WaystoneJigsawPiece.method_28880(), (App)WaystoneJigsawPiece.method_28883(), (App)WaystoneJigsawPiece.method_61013()).apply((Applicative)codecBuilder, WaystoneJigsawPiece::new));
    }
}

