/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.Signpost;
import gollorum.signpost.SignpostFabric;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Tuple;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class FabricPacketHandler
extends PacketHandler {
    private final boolean isClient;

    public static void initialize(boolean isClient) {
        instance = new FabricPacketHandler(isClient);
        instance.init();
        instance.register(new SignpostFabric.JoinServerEvent(), class_2960.method_60655((String)"signpost", (String)"join_server"));
        for (Map.Entry<class_2960, PacketHandler.Event<?>> entry : Compat.getEvents().entrySet()) {
            instance.register(entry.getValue(), entry.getKey());
        }
        for (Tuple tuple : FabricPacketHandler.instance.events) {
            ((FabricPacketHandler)instance).actuallyRegister((PacketHandler.Event)tuple._1(), (class_2960)tuple._2());
        }
    }

    private FabricPacketHandler(boolean isClient) {
        this.isClient = isClient;
    }

    private <T> void actuallyRegister(PacketHandler.Event<T> event, class_2960 id) {
        class_8710.class_9154 type = new class_8710.class_9154(id);
        PayloadTypeRegistry.playC2S().register(type, event.codec().method_56432(message -> new Payload<Object>(type, event, message), payload -> payload.message));
        PayloadTypeRegistry.playS2C().register(type, event.codec().method_56432(message -> new Payload<Object>(type, event, message), payload -> payload.message));
        if (this.isClient) {
            ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)type, FabricPacketHandler::handleOnClient);
        }
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)type, FabricPacketHandler::handleOnServer);
    }

    private static <T> void handleOnClient(Payload<T> payload, ClientPlayNetworking.Context context) {
        payload.event.handle(payload.message, new PacketHandler.Context.Client());
    }

    private static <T> void handleOnServer(Payload<T> payload, ServerPlayNetworking.Context context) {
        payload.event.handle(payload.message, new PacketHandler.Context.Server(context.player()));
    }

    private <T> Payload<T> toPayload(T message) {
        Tuple tuple = (Tuple)this.eventMap.get(message.getClass());
        return new Payload<T>(new class_8710.class_9154((class_2960)tuple._2()), (PacketHandler.Event)tuple._1(), message);
    }

    @Override
    public <T> void sendToServer(T message) {
        ClientPlayNetworking.send(this.toPayload(message));
    }

    @Override
    public <T> void sendToPlayer(class_3222 target, T message) {
        ServerPlayNetworking.send((class_3222)target, this.toPayload(message));
    }

    @Override
    public <T> void sendToTracing(class_3218 world, class_2338 pos, Supplier<T> t) {
        if (world == null) {
            Signpost.LOGGER.warn("No world to notify mutation");
        } else if (pos == null) {
            Signpost.LOGGER.warn("No position to notify mutation");
        } else {
            Payload<T> payload = this.toPayload(t.get());
            for (class_3222 player : world.method_14178().field_17254.method_17210(new class_1923(pos), false)) {
                ServerPlayNetworking.send((class_3222)player, payload);
            }
        }
    }

    @Override
    public <T> void sendToTracing(class_2586 tile, Supplier<T> t) {
        this.sendToTracing((class_3218)tile.method_10997(), tile.method_11016(), t);
    }

    @Override
    public <T> void sendToAll(T message) {
        assert (Signpost.getServerType().isServer);
        Signpost.getServerInstance().method_3760().method_14581(ServerPlayNetworking.createS2CPacket(this.toPayload(message)));
    }

    private static final class Payload<T>
    extends Record
    implements class_8710 {
        private final class_8710.class_9154<Payload<T>> type;
        private final PacketHandler.Event<T> event;
        private final T message;

        private Payload(class_8710.class_9154<Payload<T>> type, PacketHandler.Event<T> event, T message) {
            this.type = type;
            this.event = event;
            this.message = message;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Payload.class, "type;event;message", "type", "event", "message"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Payload.class, "type;event;message", "type", "event", "message"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Payload.class, "type;event;message", "type", "event", "message"}, this, o);
        }

        public class_8710.class_9154<Payload<T>> method_56479() {
            return this.type;
        }

        public PacketHandler.Event<T> event() {
            return this.event;
        }

        public T message() {
            return this.message;
        }
    }
}

