/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class PacketHandler {
    protected static PacketHandler instance = null;
    protected final List<Tuple<Event<?>, class_2960>> events = new ArrayList();
    protected final Map<Class<?>, Tuple<Event<?>, class_2960>> eventMap = new HashMap();

    public static PacketHandler getInstance() {
        return instance;
    }

    protected void init() {
        this.register(new PostTile.PartAddedEvent(), class_2960.method_60655((String)"signpost", (String)"part_added"));
        this.register(new PostTile.PartMutatedEvent(), class_2960.method_60655((String)"signpost", (String)"part_mutated"));
        this.register(new PostTile.PartRemovedEvent(), class_2960.method_60655((String)"signpost", (String)"part_removed"));
        this.register(new PostTile.UpdateAllPartsEvent(), class_2960.method_60655((String)"signpost", (String)"update_all_parts"));
        this.register(new Teleport.Request(), class_2960.method_60655((String)"signpost", (String)"teleport_request"));
        this.register(new Teleport.RequestGui(), class_2960.method_60655((String)"signpost", (String)"teleport_request_gui"));
        this.register(new RequestSignGui(), class_2960.method_60655((String)"signpost", (String)"request_sign_gui"));
        this.register(new RequestSignGui.ForNewSign(), class_2960.method_60655((String)"signpost", (String)"request_sign_gui_for_new_sign"));
        this.register(new RequestWaystoneGui(), class_2960.method_60655((String)"signpost", (String)"request_waystone_gui"));
        this.register(new WaystoneLibrary.RequestAllWaystoneNamesEvent(), class_2960.method_60655((String)"signpost", (String)"request_all_waystone_names"));
        this.register(new WaystoneLibrary.DeliverAllWaystoneNamesEvent(), class_2960.method_60655((String)"signpost", (String)"deliver_all_waystone_names"));
        this.register(new WaystoneLibrary.RequestAllWaystonesEvent(), class_2960.method_60655((String)"signpost", (String)"request_all_waystones"));
        this.register(new WaystoneLibrary.DeliverAllWaystonesEvent(), class_2960.method_60655((String)"signpost", (String)"deliver_all_waystones"));
        this.register(new WaystoneLibrary.WaystoneUpdatedEventEvent(), class_2960.method_60655((String)"signpost", (String)"waystone_updated_event"));
        this.register(new WaystoneLibrary.RequestWaystoneLocationEvent(), class_2960.method_60655((String)"signpost", (String)"request_waystone_location"));
        this.register(new WaystoneLibrary.DeliverWaystoneLocationEvent(), class_2960.method_60655((String)"signpost", (String)"deliver_waystone_location"));
        this.register(new WaystoneLibrary.RequestWaystoneAtLocationEvent(), class_2960.method_60655((String)"signpost", (String)"request_waystone_at_location"));
        this.register(new WaystoneLibrary.DeliverWaystoneAtLocationEvent(), class_2960.method_60655((String)"signpost", (String)"deliver_waystone_at_location"));
        this.register(new WaystoneLibrary.DeliverIdEvent(), class_2960.method_60655((String)"signpost", (String)"deliver_id"));
        this.register(new WaystoneLibrary.RequestIdEvent(), class_2960.method_60655((String)"signpost", (String)"request_id"));
    }

    public final <T> void register(Event<T> event, class_2960 id) {
        this.events.add(new Tuple<Event<T>, class_2960>(event, id));
        this.eventMap.put(event.getMessageClass(), new Tuple<Event<T>, class_2960>(event, id));
    }

    public abstract <T> void sendToServer(T var1);

    public abstract <T> void sendToPlayer(class_3222 var1, T var2);

    public abstract <T> void sendToTracing(class_3218 var1, class_2338 var2, Supplier<T> var3);

    public abstract <T> void sendToTracing(class_2586 var1, Supplier<T> var2);

    public abstract <T> void sendToAll(T var1);

    public static interface Event<T> {
        public Class<T> getMessageClass();

        public void handle(T var1, Context var2);

        public class_9139<class_9129, T> codec();

        public static interface ForServer<T>
        extends Event<T> {
            @Override
            default public void handle(T message, Context context) {
                if (!(context instanceof Context.Server)) {
                    throw new RuntimeException("Tried to handle server event on client");
                }
                Context.Server server = (Context.Server)context;
                this.handle(message, server);
            }

            public void handle(T var1, Context.Server var2);
        }

        public static interface ForClient<T>
        extends Event<T> {
            @Override
            default public void handle(T message, Context context) {
                if (!(context instanceof Context.Client)) {
                    throw new RuntimeException("Tried to handle client event on server");
                }
                Context.Client client = (Context.Client)context;
                this.handle(message, client);
            }

            public void handle(T var1, Context.Client var2);
        }
    }

    public static interface Context {
        public class_7225.class_7874 getHolderLookupProvider();

        public record Client() implements Context
        {
            @Override
            public class_7225.class_7874 getHolderLookupProvider() {
                return class_310.method_1551().field_1724.method_56673();
            }
        }

        public record Server(class_3222 sender) implements Context
        {
            @Override
            public class_7225.class_7874 getHolderLookupProvider() {
                return this.sender.method_56673();
            }
        }
    }
}

