/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.registry;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.worldgen.IWaystoneDiscoveryEventListener;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.utils.WaystoneData;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class WaystoneDiscoveryEventListener
implements IWaystoneDiscoveryEventListener {
    private static final int discoveryDistance = 8;

    public static void register() {
        ServerTickEvents.START_WORLD_TICK.register(WaystoneDiscoveryEventListener::onTick);
    }

    private static void onTick(class_3218 level) {
        WaystoneLibrary waystoneLibrary = WaystoneLibrary.getInstance();
        Map<VillageWaystone.ChunkEntryKey, WaystoneHandle.Vanilla> allEntries = waystoneLibrary.getVillageWaystones().getAllEntriesByChunk(waystoneLibrary, false);
        for (class_3222 player : level.method_18456()) {
            int chunkRadius = 1;
            class_1923 playerChunk = player.method_31476();
            for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                    VillageWaystone.ChunkEntryKey key = new VillageWaystone.ChunkEntryKey(new class_1923(playerChunk.field_9181 + x, playerChunk.field_9180 + z), level.method_27983().method_29177());
                    WaystoneHandle.Vanilla handle = allEntries.get(key);
                    if (handle == null || waystoneLibrary.isDiscovered(new PlayerHandle((class_1297)player), handle)) continue;
                    Optional<WaystoneData> dataOption = waystoneLibrary.getData(handle);
                    dataOption.ifPresent(data -> {
                        if (waystoneLibrary.addDiscovered(new PlayerHandle((class_1297)player), handle)) {
                            player.method_64398((class_2561)class_2561.method_43469((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(player, data.name())}));
                        }
                    });
                }
            }
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void registerNew(WaystoneHandle.Vanilla handle, class_3218 world, class_2338 pos) {
    }
}

