/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class Either<Left, Right> {
    public static <Left, Right> Either<Left, Right> left(Left left) {
        return new LeftImpl(left);
    }

    public static <Left, Right> Either<Left, Right> right(Right right) {
        return new RightImpl(right);
    }

    public static <Left, Right> Either<Left, Right> leftIfPresent(Optional<Left> left, Supplier<Right> right) {
        return left.map(Either::left).orElseGet(() -> Either.right(right.get()));
    }

    public static <Left, Right> Either<Left, Right> rightIfPresent(Optional<Right> right, Supplier<Left> left) {
        return right.map(Either::right).orElseGet(() -> Either.left(left.get()));
    }

    public static <Left, Right> Either<Left, Right> fromMojangEither(com.mojang.datafixers.util.Either<Left, Right> mojangEither) {
        return (Either)mojangEither.map(Either::left, Either::right);
    }

    public com.mojang.datafixers.util.Either<Left, Right> toMojangEither() {
        return this.match(com.mojang.datafixers.util.Either::left, com.mojang.datafixers.util.Either::right);
    }

    private Either() {
    }

    public abstract boolean isLeft();

    public boolean isRight() {
        return !this.isLeft();
    }

    public Either<Right, Left> flip() {
        return this.match(Either::right, Either::left);
    }

    public abstract Right rightOr(Function<Left, Right> var1);

    public abstract Left leftOr(Function<Right, Left> var1);

    public abstract <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> var1);

    public abstract <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> var1);

    public final <NewRight> Either<Left, NewRight> mapRight(Function<Right, NewRight> mapping) {
        return this.flatMapRight(r -> Either.right(mapping.apply(r)));
    }

    public final <NewLeft> Either<NewLeft, Right> mapLeft(Function<Left, NewLeft> mapping) {
        return this.flatMapLeft(l -> Either.left(mapping.apply(l)));
    }

    public abstract <Out> Out match(Function<Left, Out> var1, Function<Right, Out> var2);

    public abstract void consume(Consumer<Left> var1, Consumer<Right> var2);

    public Right rightOrThrow() {
        return (Right)this.rightOr(l -> {
            throw new RuntimeException("Right value was not present.");
        });
    }

    public Left leftOrThrow() {
        return (Left)this.leftOr(l -> {
            throw new RuntimeException("Left value was not present.");
        });
    }

    public static <Left, Right, TBuf extends ByteBuf> class_9139<TBuf, Either<Left, Right>> streamCodec(class_9139<? super TBuf, Left> leftCodec, class_9139<? super TBuf, Right> rightCodec) {
        return class_9135.method_57995(leftCodec, rightCodec).method_56432(Either::fromMojangEither, Either::toMojangEither);
    }

    public static <Left, Right> Codec<Either<Left, Right>> codec(Codec<Left> leftCodec, Codec<Right> rightCodec) {
        return Codec.BOOL.fieldOf("IsLeft").codec().dispatch(Either::isLeft, isLeft -> (isLeft != false ? leftCodec.xmap(Either::left, Either::leftOrThrow) : rightCodec.xmap(Either::right, Either::rightOrThrow)).fieldOf("Data"));
    }

    private static class LeftImpl<Left, Right>
    extends Either<Left, Right> {
        private final Left left;

        private LeftImpl(Left left) {
            this.left = left;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public Right rightOr(Function<Left, Right> func) {
            return func.apply(this.left);
        }

        @Override
        public Left leftOr(Function<Right, Left> func) {
            return this.left;
        }

        @Override
        public <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> mapping) {
            return Either.left(this.left);
        }

        @Override
        public <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> mapping) {
            return mapping.apply(this.left);
        }

        @Override
        public <Out> Out match(Function<Left, Out> leftMapping, Function<Right, Out> rightMapping) {
            return leftMapping.apply(this.left);
        }

        @Override
        public void consume(Consumer<Left> leftMapping, Consumer<Right> rightMapping) {
            leftMapping.accept(this.left);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeftImpl left1 = (LeftImpl)o;
            return Objects.equals(this.left, left1.left);
        }

        public int hashCode() {
            return Objects.hash(this.left);
        }

        public String toString() {
            return "Left{" + String.valueOf(this.left) + "}";
        }
    }

    private static class RightImpl<Left, Right>
    extends Either<Left, Right> {
        private final Right right;

        private RightImpl(Right right) {
            this.right = right;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public Right rightOr(Function<Left, Right> func) {
            return this.right;
        }

        @Override
        public Left leftOr(Function<Right, Left> func) {
            return func.apply(this.right);
        }

        @Override
        public <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> mapping) {
            return mapping.apply(this.right);
        }

        @Override
        public <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> mapping) {
            return Either.right(this.right);
        }

        @Override
        public <Out> Out match(Function<Left, Out> leftMapping, Function<Right, Out> rightMapping) {
            return rightMapping.apply(this.right);
        }

        @Override
        public void consume(Consumer<Left> leftMapping, Consumer<Right> rightMapping) {
            rightMapping.accept(this.right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RightImpl right1 = (RightImpl)o;
            return Objects.equals(this.right, right1.right);
        }

        public int hashCode() {
            return Objects.hash(this.right);
        }

        public String toString() {
            return "Right{" + String.valueOf(this.right) + "}";
        }
    }
}

