/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.WaystoneDataBase;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class WaystoneData
extends Record
implements WaystoneDataBase {
    private final WaystoneHandle.Vanilla handle;
    private final String name;
    private final WaystoneLocationData location;
    private final boolean isLocked;
    public static final Codec<WaystoneData> CODEC = RecordCodecBuilder.create(i -> i.group((App)WaystoneHandle.Vanilla.CODEC.fieldOf("handle").forGetter(WaystoneData::handle), (App)Codec.STRING.fieldOf("Name").forGetter(WaystoneData::name), (App)WaystoneLocationData.CODEC.fieldOf("Location").forGetter(WaystoneData::location), (App)Codec.BOOL.fieldOf("IsLocked").forGetter(WaystoneData::isLocked)).apply((Applicative)i, WaystoneData::new));
    public static final class_9139<ByteBuf, WaystoneData> STREAM_CODEC = class_9139.method_56905(WaystoneHandle.Vanilla.STREAM_CODEC, WaystoneData::handle, (class_9139)class_9135.field_48554, WaystoneData::name, WaystoneLocationData.STREAM_CODEC, WaystoneData::location, (class_9139)class_9135.field_48547, WaystoneData::isLocked, WaystoneData::new);

    public WaystoneData(WaystoneHandle.Vanilla handle, String name, WaystoneLocationData location, boolean isLocked) {
        this.handle = handle;
        this.name = name;
        this.location = location;
        this.isLocked = isLocked;
    }

    public WaystoneData withoutExplicitLevel() {
        if (this.location.block().world().isLeft()) {
            return new WaystoneData(this.handle, this.name, new WaystoneLocationData(WorldLocation.from(this.location.block().blockPos(), Either.right(this.location.block().world().leftOrThrow().method_27983().method_29177())), this.location.spawn()), this.isLocked);
        }
        return this;
    }

    public WaystoneData withName(String newName) {
        return new WaystoneData(this.handle, newName, this.location, this.isLocked);
    }

    public boolean hasThePermissionToEdit(class_1657 player) {
        return WaystoneData.hasThePermissionToEdit(player, this.location, this.isLocked);
    }

    public static boolean hasThePermissionToEdit(class_1657 player, WaystoneLocationData locationData, boolean isLocked) {
        return !isLocked || WaystoneData.hasSecurityPermissions(player, locationData);
    }

    public static boolean hasSecurityPermissions(class_1657 player, WaystoneLocationData locationData) {
        return player.method_64475(IConfig.IServer.getInstance().permissions().editLockedWaystoneCommandPermissionLevel()) || TileEntityUtils.toWorld(locationData.block().world(), !(player instanceof class_3222)).map(w -> w.method_8321(locationData.block().blockPos())).flatMap(tile -> tile instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)tile).getWaystoneOwner() : Optional.empty()).map(owner -> owner.id().equals(player.method_5667())).orElse(true) != false;
    }

    @Override
    public WaystoneLocationData loc() {
        return this.location;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WaystoneData.class, "handle;name;location;isLocked", "handle", "name", "location", "isLocked"}, this, o);
    }

    @Override
    public WaystoneHandle.Vanilla handle() {
        return this.handle;
    }

    @Override
    public String name() {
        return this.name;
    }

    public WaystoneLocationData location() {
        return this.location;
    }

    public boolean isLocked() {
        return this.isLocked;
    }
}

