/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.WorldSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public record WorldLocation(class_2338 blockPos, Either<class_1937, class_2960> world) {
    public static final Codec<WorldLocation> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPosSerializer.CODEC.fieldOf("Pos").forGetter(WorldLocation::blockPos), (App)WorldSerializer.MAP_CODEC.fieldOf("Level").forGetter(WorldLocation::world)).apply((Applicative)i, WorldLocation::from));
    public static final class_9139<ByteBuf, WorldLocation> STREAM_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, WorldLocation::blockPos, WorldSerializer.STREAM_CODEC, WorldLocation::world, WorldLocation::from);

    public static Optional<WorldLocation> from(class_2586 tile) {
        return tile != null && tile.method_11002() ? Optional.of(WorldLocation.from(tile.method_11016(), tile.method_10997())) : Optional.empty();
    }

    public static WorldLocation from(class_2338 blockPos, Either<class_1937, class_2960> world) {
        return new WorldLocation(blockPos, world.mapRight(loc -> loc.method_12832().equals("") ? class_1937.field_25179.method_29177() : loc));
    }

    public static WorldLocation from(class_2338 blockPos, class_1937 world) {
        return WorldLocation.from(blockPos, Either.left(world));
    }

    public static WorldLocation from(class_2338 blockPos, class_2960 dimensionKeyLocation) {
        return WorldLocation.from(blockPos, Either.right(dimensionKeyLocation));
    }

    public WorldLocation withoutExplicitLevel() {
        if (this.world.isLeft()) {
            return WorldLocation.from(this.blockPos, Either.right(this.world.leftOrThrow().method_27983().method_29177()));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldLocation that = (WorldLocation)o;
        return this.blockPos.equals((Object)that.blockPos) && this.world.rightOr(w -> w.method_27983().method_29177()).equals((Object)that.world.rightOr(w -> w.method_27983().method_29177()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.blockPos, this.world.rightOr(w -> w.method_27983().method_29177()));
    }

    @Override
    public String toString() {
        return String.format("(%d %d %d) in %s", this.blockPos.method_10263(), this.blockPos.method_10264(), this.blockPos.method_10260(), this.world.match(class_1937::method_31419, class_2960::toString));
    }
}

