/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_238;

public class AABB
implements Intersectable<Ray, Float> {
    public final Vector3 min;
    public final Vector3 max;

    public AABB(Vector3 ... vectors) {
        this.min = Arrays.stream(vectors).reduce(Vector3::min).get();
        this.max = Arrays.stream(vectors).reduce(Vector3::max).get();
    }

    public AABB(Stream<Vector3> vectors) {
        Tuple tuple = vectors.map((? super T v) -> Tuple.of(v, v)).reduce((l, r) -> Tuple.of(Vector3.min((Vector3)l._1(), (Vector3)r._1()), Vector3.max((Vector3)l._2(), (Vector3)r._2()))).get();
        this.min = (Vector3)tuple._1();
        this.max = (Vector3)tuple._2();
    }

    @Override
    public Optional<Float> IntersectWith(Ray ray) {
        Vector3 dirFrac = ray.dir.map(f -> Float.valueOf(1.0f / f.floatValue()));
        Vector3 t1 = this.min.map(ray.start, dirFrac, a -> b -> c -> Float.valueOf((a.floatValue() - b.floatValue()) * c.floatValue()));
        Vector3 t2 = this.max.map(ray.start, dirFrac, a -> b -> c -> Float.valueOf((a.floatValue() - b.floatValue()) * c.floatValue()));
        float tmin = Vector3.min(t1, t2).max();
        float tmax = Vector3.max(t1, t2).min();
        return tmax >= 0.0f && tmin <= tmax ? Optional.of(Float.valueOf(tmin)) : Optional.empty();
    }

    @Override
    public AABB getBounds() {
        return this;
    }

    public AABB map(Function<Float, Float> f) {
        return new AABB(this.min.map(f), this.max.map(f));
    }

    public AABB apply(Function<Vector3, Vector3> f) {
        return new AABB((Vector3[])Arrays.stream(this.allCorners()).map(f).toArray(Vector3[]::new));
    }

    public AABB offset(Vector3 v) {
        return new AABB(v.add(this.min), v.add(this.max));
    }

    public class_238 asMinecraftBB() {
        return new class_238(this.min.asVec3(), this.max.asVec3());
    }

    public Vector3[] allCorners() {
        Vector3[] ret = new Vector3[]{this.min, new Vector3(this.max.x(), this.min.y(), this.min.z()), new Vector3(this.min.x(), this.max.y(), this.min.z()), new Vector3(this.min.x(), this.min.y(), this.max.z()), new Vector3(this.max.x(), this.max.y(), this.min.z()), new Vector3(this.max.x(), this.min.y(), this.max.z()), new Vector3(this.min.x(), this.max.y(), this.max.z()), new Vector3(this.max.x(), this.max.y(), this.max.z())};
        return ret;
    }
}

