/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector4;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector3f;
import org.joml.Vector4f;

public record Vector3(float x, float y, float z) {
    public static final Vector3 ZERO = new Vector3(0.0f, 0.0f, 0.0f);
    public static final Codec<Vector3> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("X").forGetter(Vector3::x), (App)Codec.FLOAT.fieldOf("Y").forGetter(Vector3::y), (App)Codec.FLOAT.fieldOf("Z").forGetter(Vector3::z)).apply((Applicative)i, Vector3::new));
    public static final class_9139<ByteBuf, Vector3> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48552, Vector3::x, (class_9139)class_9135.field_48552, Vector3::y, (class_9139)class_9135.field_48552, Vector3::z, Vector3::new);

    public static Vector3 fromVec3d(class_243 vec) {
        return new Vector3((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350);
    }

    public static Vector3 fromVector3f(Vector3f vec) {
        return new Vector3(vec.x(), vec.y(), vec.z());
    }

    public static Vector3 fromVector4f(Vector4f vec) {
        return new Vector3(vec.x(), vec.y(), vec.z());
    }

    public class_243 asVec3() {
        return new class_243((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3f asVec3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static Vector3 fromBlockPos(class_2338 vec) {
        return new Vector3(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public class_2338 toBlockPos() {
        return new class_2338((int)this.x, (int)this.y, (int)this.z);
    }

    public static Vector3 min(Vector3 a, Vector3 b) {
        return new Vector3(Float.min(a.x, b.x), Float.min(a.y, b.y), Float.min(a.z, b.z));
    }

    public static Vector3 max(Vector3 a, Vector3 b) {
        return new Vector3(Float.max(a.x, b.x), Float.max(a.y, b.y), Float.max(a.z, b.z));
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3 subtract(Vector3 other) {
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3 add(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x + otherX, this.y + otherY, this.z + otherZ);
    }

    public Vector3 subtract(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x - otherX, this.y - otherY, this.z - otherZ);
    }

    public Vector3 div(Float other) {
        return new Vector3(this.x / other.floatValue(), this.y / other.floatValue(), this.z / other.floatValue());
    }

    public Vector3 negated() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 mul(float f) {
        return new Vector3(this.x * f, this.y * f, this.z * f);
    }

    public Vector3 mul(Vector3 other) {
        return new Vector3(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3 rotateY(Angle angle) {
        return new Vector3((float)(angle.cos() * (double)this.x + angle.sin() * (double)this.z), this.y, (float)(angle.sin() * (double)this.x + angle.cos() * (double)this.z));
    }

    public float distanceTo(Vector3 other) {
        Vector3 distance = other.subtract(this);
        return (float)Math.sqrt(distance.x * distance.x + distance.y * distance.y + distance.z * distance.z);
    }

    public Vector3 map(Function<Float, Float> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).floatValue(), f.apply(Float.valueOf(this.y)).floatValue(), f.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Function<Float, Function<Float, Float>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Vector3 c, Function<Float, Function<Float, Function<Float, Float>>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).apply(Float.valueOf(c.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).apply(Float.valueOf(c.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).apply(Float.valueOf(c.z)).floatValue());
    }

    public float max() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public float min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public Vector3 withX(float x) {
        return new Vector3(x, this.y, this.z);
    }

    public Vector3 withX(Function<Float, Float> mapping) {
        return new Vector3(mapping.apply(Float.valueOf(this.x)).floatValue(), this.y, this.z);
    }

    public Vector3 withY(float y) {
        return new Vector3(this.x, y, this.z);
    }

    public Vector3 withY(Function<Float, Float> mapping) {
        return new Vector3(this.x, mapping.apply(Float.valueOf(this.y)).floatValue(), this.z);
    }

    public Vector3 withZ(float z) {
        return new Vector3(this.x, this.y, z);
    }

    public Vector3 withZ(Function<Float, Float> mapping) {
        return new Vector3(this.x, this.y, mapping.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector4 withW(float w) {
        return new Vector4(this.x, this.y, this.z, w);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        return Float.compare(vector3.x, this.x) == 0 && Float.compare(vector3.y, this.y) == 0 && Float.compare(vector3.z, this.z) == 0;
    }

    public Vector3 normalized() {
        float length = this.length();
        return new Vector3(this.x / length, this.y / length, this.z / length);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

