/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.Vector3;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Vector4(float x, float y, float z, float w) {
    public static final Vector4 ZERO = new Vector4(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Codec<Vector4> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("X").forGetter(Vector4::x), (App)Codec.FLOAT.fieldOf("Y").forGetter(Vector4::y), (App)Codec.FLOAT.fieldOf("Z").forGetter(Vector4::z), (App)Codec.FLOAT.fieldOf("W").forGetter(Vector4::w)).apply((Applicative)i, Vector4::new));
    public static final class_9139<ByteBuf, Vector4> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48552, Vector4::x, (class_9139)class_9135.field_48552, Vector4::y, (class_9139)class_9135.field_48552, Vector4::z, (class_9139)class_9135.field_48552, Vector4::w, Vector4::new);

    public Vector4 add(Vector4 other) {
        return new Vector4(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
    }

    public Vector4 subtract(Vector4 other) {
        return new Vector4(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
    }

    public Vector4 mul(float f) {
        return new Vector4(this.x * f, this.y * f, this.z * f, this.w * f);
    }

    public Vector4 mul(Vector4 other) {
        return new Vector4(this.x * other.x, this.y * other.y, this.z * other.z, this.w * other.w);
    }

    public Vector4 mul(Matrix4x4 mat) {
        return new Vector4(mat.m00 * this.x + mat.m01 * this.y + mat.m02 * this.z + mat.m03 * this.w, mat.m10 * this.x + mat.m11 * this.y + mat.m12 * this.z + mat.m13 * this.w, mat.m20 * this.x + mat.m21 * this.y + mat.m22 * this.z + mat.m23 * this.w, mat.m30 * this.x + mat.m31 * this.y + mat.m32 * this.z + mat.m33 * this.w);
    }

    public Vector4 map(Function<Float, Float> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).floatValue(), f.apply(Float.valueOf(this.y)).floatValue(), f.apply(Float.valueOf(this.z)).floatValue(), f.apply(Float.valueOf(this.w)).floatValue());
    }

    public Vector4 map(Vector4 b, Function<Float, Function<Float, Float>> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).floatValue(), f.apply(Float.valueOf(this.w)).apply(Float.valueOf(b.w)).floatValue());
    }

    public Vector4 map(Vector4 b, Vector4 c, Function<Float, Function<Float, Function<Float, Float>>> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).apply(Float.valueOf(c.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).apply(Float.valueOf(c.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).apply(Float.valueOf(c.z)).floatValue(), f.apply(Float.valueOf(this.w)).apply(Float.valueOf(b.w)).apply(Float.valueOf(c.w)).floatValue());
    }

    public float max() {
        return Math.max(Math.max(Math.max(this.x, this.y), this.z), this.w);
    }

    public float min() {
        return Math.max(Math.min(Math.min(this.x, this.y), this.z), this.w);
    }

    public float dot(Vector4 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public Vector3 xyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector4 Vector42 = (Vector4)o;
        return Float.compare(Vector42.x, this.x) == 0 && Float.compare(Vector42.y, this.y) == 0 && Float.compare(Vector42.z, this.z) == 0 && Float.compare(Vector42.w, this.w) == 0;
    }
}

