/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.mixin.ProcessorListsAccessor;
import gollorum.signpost.mixin.StructureTemplatePoolAccessor;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9822;

public class Villages {
    public static final Villages instance = new Villages();
    private class_6880<class_5497> waystoneProcessorListDesert;
    private class_6880<class_5497> waystoneProcessorListPlains;
    private class_6880<class_5497> waystoneProcessorListSavanna;
    private class_6880<class_5497> waystoneProcessorListSnowyOrTaiga;

    private Villages() {
    }

    private void registerProcessorLists(class_5455 registryAccess) {
        Optional optionalReg = registryAccess.method_46759(class_7924.field_41247);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: ProcessorList registry not found");
            return;
        }
        class_2378 reg = (class_2378)optionalReg.get();
        this.waystoneProcessorListDesert = reg.method_46747(ProcessorListsAccessor.getEmpty());
        this.waystoneProcessorListPlains = reg.method_46747(class_5469.field_26267);
        this.waystoneProcessorListSavanna = reg.method_46747(class_5469.field_26268);
        this.waystoneProcessorListSnowyOrTaiga = reg.method_46747(class_5469.field_26269);
    }

    public static void reset() {
        VillageSignpost.reset();
        VillageWaystone.reset();
        SignpostJigsawPiece.reset();
        WaystoneJigsawPiece.reset();
    }

    public void initialize(class_5455 registryAccess) {
        this.registerProcessorLists(registryAccess);
        Optional optionalReg = registryAccess.method_46759(class_7924.field_41249);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: TemplatePool registry not found");
            return;
        }
        class_2378 reg = (class_2378)optionalReg.get();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true, (class_2378<class_3785>)reg);
            this.registerFor(villageType, false, (class_2378<class_3785>)reg);
        }
        Villages.reset();
    }

    private void registerFor(VillageType villageType, boolean isZombie, class_2378<class_3785> registry) {
        this.addToPool((Collection<Tuple<class_3781, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getWaystoneStructureResourceLocation("waystone"), villageType.processorList, class_3785.class_3786.field_16687, Optional.empty()), 1), Tuple.of(new SignpostJigsawPiece(villageType.getSignpostStructureResourceLocation("signpost"), villageType.processorList, class_3785.class_3786.field_16686, Optional.of(class_9822.field_52238), isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType), registry);
    }

    private static class_2960 getVillagePool(VillageType villageType) {
        return class_2960.method_60654((String)("village/" + villageType.name + "/houses"));
    }

    private static class_2960 getZombieVillagePool(VillageType villageType) {
        return class_2960.method_60654((String)("village/" + villageType.name + "/zombie/houses"));
    }

    private void addToPool(Collection<Tuple<class_3781, Integer>> houses, class_2960 poolKey, class_2378<class_3785> registry) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)poolKey);
        class_3785 pool = (class_3785)registry.method_29107(key);
        if (pool == null) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + String.valueOf(poolKey) + ", but it was not found in the registry.");
            return;
        }
        StructureTemplatePoolAccessor templatePool = (StructureTemplatePoolAccessor)pool;
        ArrayList<Pair<class_3784, Integer>> templates = new ArrayList<Pair<class_3784, Integer>>(templatePool.getRawTemplates());
        for (Tuple<class_3781, Integer> tuple : houses) {
            templates.add((Pair<class_3784, Integer>)new Pair((Object)((class_3784)tuple._1()), (Object)tuple._2()));
            for (int i = 0; i < tuple._2(); ++i) {
                templatePool.getTemplates().add((Object)((class_3784)tuple._1()));
            }
        }
        templatePool.setRawTemplates(templates);
    }

    private static enum VillageType {
        Desert("desert", Villages.instance.waystoneProcessorListDesert, false),
        Plains("plains", Villages.instance.waystoneProcessorListPlains, true),
        Savanna("savanna", Villages.instance.waystoneProcessorListSavanna, true),
        Snowy("snowy", Villages.instance.waystoneProcessorListSnowyOrTaiga, true),
        Taiga("taiga", Villages.instance.waystoneProcessorListSnowyOrTaiga, true);

        public final String name;
        public final class_6880<class_5497> processorList;
        public final boolean isCommonGround;

        private VillageType(String name, class_6880<class_5497> processorList, boolean isCommonGround) {
            this.name = name;
            this.processorList = processorList;
            this.isCommonGround = isCommonGround;
        }

        public class_2960 getSignpostStructureResourceLocation(String structureName) {
            return class_2960.method_60655((String)"signpost", (String)("village/" + this.name + "/" + structureName));
        }

        public class_2960 getWaystoneStructureResourceLocation(String structureName) {
            return class_2960.method_60655((String)"signpost", (String)("village/" + (this.isCommonGround ? "common" : this.name) + "/" + structureName));
        }
    }
}

