/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class WalletUpgradeRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public WalletUpgradeRecipe(String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> ingredients) {
        this.group = groupIn;
        this.category = category;
        this.recipeOutput = recipeOutputIn;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.WALLET_UPGRADE.get();
    }

    @Nonnull
    public String getGroup() {
        return this.group;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider lookup) {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput container, @Nonnull Level level) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < container.size(); ++j) {
            ItemStack itemstack = container.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider lookup) {
        ItemStack output = this.recipeOutput.copy();
        ItemStack walletStack = this.getWalletStack(inv);
        if (!walletStack.isEmpty()) {
            output = walletStack.transmuteCopy((ItemLike)output.getItem(), 1);
        }
        return output;
    }

    private ItemStack getWalletStack(CraftingInput inv) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof WalletItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    @Nonnull
    public CraftingBookCategory category() {
        return this.category;
    }

    public static class Serializer
    implements RecipeSerializer<WalletUpgradeRecipe> {
        @Nonnull
        private static WalletUpgradeRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory c = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new WalletUpgradeRecipe(s, c, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull WalletUpgradeRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.recipeOutput);
        }

        @Nonnull
        public MapCodec<WalletUpgradeRecipe> codec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.recipeOutput), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(var -> {
                Object[] aingredient = (Ingredient[])var.toArray(Ingredient[]::new);
                if (aingredient.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
            }, DataResult::success).forGetter(r -> r.ingredients)).apply((Applicative)builder, WalletUpgradeRecipe::new));
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, WalletUpgradeRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }
    }
}

