/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.RepairWithMoneyData;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.wallet.SPacketPlayCoinSound;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class MoneyMendingEnchantment {
    public static MoneyValue getRepairCost(@Nonnull ItemStack item, @Nonnull RepairWithMoneyData data, @Nonnull HolderLookup.Provider lookup) {
        MoneyValue baseCost = data.getBaseCost();
        ItemEnchantments enchantments = item.getItem() == Items.ENCHANTED_BOOK ? (ItemEnchantments)item.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY) : item.getAllEnchantments(lookup.lookupOrThrow(Registries.ENCHANTMENT));
        MoneyValue cost = data.getRepairCost(item, enchantments);
        return cost == null ? baseCost : cost;
    }

    public static void runEntityTick(@Nonnull LivingEntity entity, @Nonnull IMoneyHandler handler) {
        Optional entry = EnchantmentHelper.getRandomItemWith(ModEnchantments.REPAIR_WITH_MONEY.get(), (LivingEntity)entity, ItemStack::isDamaged);
        ItemStack item = null;
        if (entry.isEmpty()) {
            if (LCCurios.isLoaded()) {
                item = LCCurios.getRandomItem(entity, s -> s.isDamaged() && EnchantmentHelper.has((ItemStack)s, ModEnchantments.REPAIR_WITH_MONEY.get()));
            }
        } else {
            item = ((EnchantedItemInUse)entry.get()).itemStack();
        }
        if (item != null) {
            Pair dataPair = EnchantmentHelper.getHighestLevel((ItemStack)item, ModEnchantments.REPAIR_WITH_MONEY.get());
            if (dataPair == null) {
                LightmansCurrency.LogWarning("Money Mending item was missing its RepairWithMoney data");
                return;
            }
            RepairWithMoneyData data = (RepairWithMoneyData)dataPair.getFirst();
            MoneyValue repairCost = MoneyMendingEnchantment.getRepairCost(item, data, (HolderLookup.Provider)entity.registryAccess());
            MoneyView availableFunds = handler.getStoredMoney();
            if (!availableFunds.containsValue(repairCost)) {
                return;
            }
            MoneyValue nextCost = repairCost;
            MoneyValue finalCost = MoneyValue.empty();
            int currentDamage = item.getDamageValue();
            int repairAmount = 0;
            while (availableFunds.containsValue(nextCost) && repairAmount < currentDamage) {
                ++repairAmount;
                finalCost = nextCost;
                nextCost = nextCost.addValue(repairCost);
            }
            if (handler.extractMoney(finalCost, true).isEmpty()) {
                handler.extractMoney(finalCost, false);
                item.setDamageValue(currentDamage - repairAmount);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    SPacketPlayCoinSound.INSTANCE.sendTo(player);
                }
            }
        }
    }

    public static void addEnchantmentTooltips(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip, @Nonnull Item.TooltipContext context) {
        if (context.registries() == null) {
            return;
        }
        if (stack.getItem() == Items.ENCHANTED_BOOK) {
            if (!stack.has(DataComponents.STORED_ENCHANTMENTS)) {
                return;
            }
            ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                try {
                    RepairWithMoneyData data;
                    Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                    ResourceKey key = ((Holder)entry.getKey()).unwrapKey().orElse(null);
                    if (enchantment == null || (data = (RepairWithMoneyData)((Enchantment)((Holder)entry.getKey()).value()).effects().get(ModEnchantments.REPAIR_WITH_MONEY.get())) == null) continue;
                    TooltipItem.insertTooltip(tooltip, MoneyMendingEnchantment.infoTooltip(stack, data, context.registries()));
                }
                catch (Throwable t) {
                    LightmansCurrency.LogDebug("Error checking item enchantments.", t);
                }
            }
        } else {
            Pair data = EnchantmentHelper.getHighestLevel((ItemStack)stack, ModEnchantments.REPAIR_WITH_MONEY.get());
            if (data != null) {
                TooltipItem.insertTooltip(tooltip, MoneyMendingEnchantment.infoTooltip(stack, (RepairWithMoneyData)data.getFirst(), context.registries()));
            }
        }
    }

    private static Component infoTooltip(@Nonnull ItemStack stack, @Nonnull RepairWithMoneyData data, @Nonnull HolderLookup.Provider lookup) {
        return LCText.TOOLTIP_MONEY_MENDING_COST.get(MoneyMendingEnchantment.getRepairCost(stack, data, lookup).getText().withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
    }
}

