/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.data.TicketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TicketItem
extends Item {
    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (stack.has(ModDataComponents.TICKET_DATA)) {
            TicketData oldData = (TicketData)stack.get(ModDataComponents.TICKET_DATA);
            stack.remove(ModDataComponents.TICKET_DATA);
            stack.set(ModDataComponents.TICKET_ID, (Object)oldData.id());
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(oldData.color(), false));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        long ticketID;
        if (TicketItem.isPass(stack)) {
            tooltip.add((Component)LCText.TOOLTIP_PASS.get(new Object[0]));
            if (stack.has(ModDataComponents.TICKET_USES)) {
                tooltip.add((Component)LCText.TOOLTIP_TICKET_USES.get(stack.get(ModDataComponents.TICKET_USES)).withStyle(ChatFormatting.GRAY));
            }
        }
        if ((ticketID = TicketItem.GetTicketID(stack)) >= -2L) {
            tooltip.add((Component)LCText.TOOLTIP_TICKET_ID.get(ticketID));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public static boolean isTicket(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_ID)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_TICKET);
    }

    public static boolean isPass(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_ID)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_PASS);
    }

    public static boolean isInfinitePass(ItemStack ticket) {
        return TicketItem.isPass(ticket) && !ticket.has(ModDataComponents.TICKET_USES);
    }

    public static boolean isTicketOrPass(ItemStack ticket) {
        return TicketItem.isTicket(ticket) || TicketItem.isPass(ticket);
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_ID)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_MASTER);
    }

    public static long GetTicketID(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem) || !ticket.has(ModDataComponents.TICKET_ID)) {
            return Long.MIN_VALUE;
        }
        return (Long)ticket.get(ModDataComponents.TICKET_ID);
    }

    public static int GetTicketColor(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem) || !ticket.has(ModDataComponents.TICKET_ID)) {
            return 0xFFFFFF;
        }
        return ((DyedItemColor)ticket.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF, false))).rgb();
    }

    public static int GetDefaultTicketColor(long ticketID) {
        if (ticketID == -1L) {
            return Color.YELLOW.hexColor;
        }
        if (ticketID == -2L) {
            return Color.BLUE.hexColor;
        }
        return Color.getFromIndex((long)ticketID).hexColor;
    }

    public static ItemStack CraftTicket(ItemStack master, Item item) {
        if (TicketItem.isMasterTicket(master)) {
            return TicketItem.CreateTicket(item, TicketItem.GetTicketID(master), TicketItem.GetTicketColor(master));
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack CreateTicket(Item item, long ticketID) {
        return TicketItem.CreateTicket(item, ticketID, TicketItem.GetDefaultTicketColor(ticketID));
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color) {
        return TicketItem.CreateTicket(item, ticketID, color, 1);
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color, int count) {
        ItemStack ticket = new ItemStack((ItemLike)item, count);
        ticket.set(ModDataComponents.TICKET_ID, (Object)ticketID);
        ticket.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
        return ticket;
    }

    public static int getUseCount(ItemStack ticket) {
        return (Integer)ticket.getOrDefault(ModDataComponents.TICKET_USES, (Object)0);
    }

    public static void setUseCount(ItemStack ticket, int useCount) {
        ticket.set(ModDataComponents.TICKET_USES, (Object)useCount);
    }

    public static ItemStack damageTicket(ItemStack ticket) {
        ItemStack result = ItemStack.EMPTY;
        int uses = TicketItem.getUseCount(ticket);
        if (uses > 0) {
            if (ticket.getCount() > 1) {
                result = ticket = ticket.split(1);
            }
            if (uses == 1) {
                ticket.shrink(1);
            } else {
                TicketItem.setUseCount(ticket, uses - 1);
            }
        }
        return result;
    }

    public static ItemStack CreateExampleTicket(Item item, Color color) {
        ItemStack ticket = new ItemStack((ItemLike)item);
        ticket.set(ModDataComponents.TICKET_ID, (Object)Long.MIN_VALUE);
        ticket.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color.hexColor, false));
        return ticket;
    }

    public static void SetTicketColor(ItemStack ticket, Color color) {
        TicketItem.SetTicketColor(ticket, color.hexColor);
    }

    public static void SetTicketColor(ItemStack ticket, int color) {
        ticket.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
    }
}

