/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.data;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemData {
    private final ItemStack stack;
    private final Component deprecatedName;
    private final String customName;

    public ItemData(@Nonnull ItemStack stack) {
        this(stack, null, "");
    }

    public ItemData(@Nonnull ItemStack stack, @Nonnull String customName) {
        this(stack, null, customName);
    }

    public ItemData(@Nonnull ItemStack stack, @Nullable Component deprecatedName, @Nonnull String customName) {
        this.stack = stack;
        this.deprecatedName = deprecatedName;
        this.customName = customName;
    }

    private ItemData(@Nonnull Component deprecatedName, int count) {
        this.stack = new ItemStack((ItemLike)Items.BARRIER, count);
        this.deprecatedName = deprecatedName;
        this.customName = "";
    }

    public Component getName() {
        if (this.deprecatedName != null) {
            return this.deprecatedName;
        }
        return this.customName.isEmpty() ? EasyText.empty().append(this.stack.getHoverName()) : EasyText.literal(this.customName);
    }

    public MutableComponent format() {
        return LCText.NOTIFICATION_ITEM_FORMAT.get(this.stack.getCount(), this.getName());
    }

    public MutableComponent formatWith(@Nonnull ItemData other) {
        return LCText.GUI_AND.get(this.format(), other.format());
    }

    public MutableComponent formatWith(@Nonnull MutableComponent other) {
        return LCText.GUI_AND.get(this.format(), other);
    }

    public static MutableComponent format(@Nonnull ItemData d1, @Nonnull ItemData d2) {
        if (d1.stack.isEmpty() && d2.stack.isEmpty()) {
            return EasyText.literal("ERROR");
        }
        if (d1.stack.isEmpty()) {
            return d2.format();
        }
        if (d2.stack.isEmpty()) {
            return d1.format();
        }
        return d1.formatWith(d2);
    }

    @Nonnull
    public CompoundTag save(@Nonnull HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        tag.put("Stack", (Tag)InventoryUtil.saveItemNoLimits(this.stack, lookup));
        tag.putString("CustomName", this.customName);
        if (this.deprecatedName != null) {
            tag.putString("DeprecatedName", Component.Serializer.toJson((Component)this.deprecatedName, (HolderLookup.Provider)lookup));
        }
        return tag;
    }

    public static ItemData load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        if (tag.contains("Empty")) {
            return new ItemData(ItemStack.EMPTY, "");
        }
        if (tag.contains("Name")) {
            MutableComponent deprecatedName = Component.Serializer.fromJson((String)tag.getString("Name"), (HolderLookup.Provider)lookup);
            int count = tag.getInt("Count");
            return new ItemData((Component)deprecatedName, count);
        }
        ItemStack stack = InventoryUtil.loadItemNoLimits(tag.getCompound("Stack"), lookup);
        String customName = tag.getString("CustomName");
        MutableComponent deprecatedName = null;
        if (tag.contains("DeprecatedName")) {
            deprecatedName = Component.Serializer.fromJson((String)tag.getString("DeprecatedName"), (HolderLookup.Provider)lookup);
        }
        return new ItemData(stack, (Component)deprecatedName, customName);
    }

    public boolean matches(@Nonnull ItemData other) {
        if (this.deprecatedName != null || other.deprecatedName != null) {
            return false;
        }
        return this.customName.equals(other.customName) && InventoryUtil.ItemsFullyMatch(this.stack, other.stack);
    }

    public static Component getItemNames(List<ItemData> items) {
        MutableComponent result = null;
        for (ItemData item : items) {
            if (result != null) {
                result = item.formatWith(result);
                continue;
            }
            result = item.format();
        }
        return result == null ? Component.literal((String)"ERROR") : result;
    }
}

