/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class EmptyHolder<T>
implements Holder<T> {
    private final ResourceKey<T> key;

    public EmptyHolder(@Nonnull ResourceKey<T> key) {
        this.key = key;
    }

    @Nonnull
    public T value() {
        throw new RuntimeException("Attempted to get value of an empty key!");
    }

    public boolean isBound() {
        return false;
    }

    public boolean is(@Nonnull ResourceLocation id) {
        return this.key.location().equals((Object)id);
    }

    public boolean is(@Nonnull ResourceKey<T> key) {
        return this.key.equals(key);
    }

    public boolean is(@Nonnull Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(@Nonnull TagKey<T> tagKey) {
        return false;
    }

    public boolean is(@Nonnull Holder<T> holder) {
        return holder.is(this.key);
    }

    @Nonnull
    public Stream<TagKey<T>> tags() {
        return Stream.empty();
    }

    @Nonnull
    public Either<ResourceKey<T>, T> unwrap() {
        return Either.left(this.key);
    }

    @Nonnull
    public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.key);
    }

    @Nonnull
    public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    public boolean canSerializeIn(@Nonnull HolderOwner<T> owner) {
        return true;
    }
}

