/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VariantAttributeType
implements ItemAttributeType {
    private static final ResourceLocation NULL_ID = VersionUtil.modResource("null", "null");
    private static final VariantAttribute NO_VARIANT_ATTRIBUTE = new VariantAttribute(NULL_ID);
    public static final MapCodec<VariantAttribute> CODEC = ResourceLocation.CODEC.xmap(VariantAttribute::create, VariantAttribute::variantID).fieldOf("value");
    public static final StreamCodec<RegistryFriendlyByteBuf, VariantAttribute> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, VariantAttribute::variantID, VariantAttribute::create);

    @Nonnull
    public ItemAttribute createAttribute() {
        return new VariantAttribute(VersionUtil.lcResource("null"));
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        BlockItem bi;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof IVariantBlock) {
            ResourceLocation variantID = (ResourceLocation)stack.getOrDefault(ModDataComponents.MODEL_VARIANT, null);
            if (variantID != null) {
                return List.of(new VariantAttribute(variantID));
            }
            return List.of(NO_VARIANT_ATTRIBUTE);
        }
        return List.of();
    }

    public MapCodec<? extends ItemAttribute> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
        return STREAM_CODEC;
    }

    public record VariantAttribute(ResourceLocation variantID) implements ItemAttribute
    {
        private static VariantAttribute create(ResourceLocation variantID) {
            if (variantID.equals((Object)NULL_ID)) {
                return NO_VARIANT_ATTRIBUTE;
            }
            return new VariantAttribute(variantID);
        }

        private boolean isNullType() {
            return this.variantID.equals((Object)NULL_ID);
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            ResourceLocation variant = (ResourceLocation)stack.getOrDefault(ModDataComponents.MODEL_VARIANT, null);
            if (this.isNullType()) {
                return variant == null;
            }
            return Objects.equals(this.variantID, variant);
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.VARIANT_ATTRIBUTE.get();
        }

        public String getTranslationKey() {
            return this.isNullType() ? "lightmanscurrency.model_variant.null" : "lightmanscurrency.model_variant";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.isNullType()) {
                objectArray = super.getTranslationParameters();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.variantID.toString();
            }
            return objectArray;
        }
    }
}

