/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WalletAttributeType
implements ItemAttributeType {
    public static final MapCodec<WalletAttribute> CODEC = Codec.STRING.xmap(WalletAttributeType::parse, a -> a.ability.name()).fieldOf("ability");
    public static final StreamCodec<ByteBuf, WalletAttribute> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(WalletAttributeType::parse, a -> a.ability.name());
    private static final WalletAttribute PICKUP_ABILITY = new WalletAttribute(AbilityType.PICKUP);
    private static final WalletAttribute EXCHANGE_ABILITY = new WalletAttribute(AbilityType.EXCHANGE);
    private static final WalletAttribute BANK_ABILITY = new WalletAttribute(AbilityType.BANK);

    public ItemAttribute createAttribute() {
        return new WalletAttribute(AbilityType.PICKUP);
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        ArrayList<ItemAttribute> result = new ArrayList<ItemAttribute>();
        Item item = stack.getItem();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            if (WalletItem.CanExchange(wallet)) {
                result.add(EXCHANGE_ABILITY);
            }
            if (WalletItem.CanPickup(wallet)) {
                result.add(PICKUP_ABILITY);
            }
            if (WalletItem.HasBankAccess(wallet)) {
                result.add(BANK_ABILITY);
            }
        }
        return result;
    }

    public MapCodec<? extends ItemAttribute> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
        return STREAM_CODEC;
    }

    private static WalletAttribute parse(String abilityType) {
        return switch (((AbilityType)EnumUtil.enumFromString((String)abilityType, (Enum[])AbilityType.values(), (Enum)AbilityType.PICKUP)).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> PICKUP_ABILITY;
            case 0 -> EXCHANGE_ABILITY;
            case 2 -> BANK_ABILITY;
        };
    }

    public record WalletAttribute(AbilityType ability) implements ItemAttribute
    {
        public boolean appliesTo(ItemStack stack, Level world) {
            Item item = stack.getItem();
            if (item instanceof WalletItem) {
                WalletItem wallet = (WalletItem)item;
                return switch (this.ability.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> WalletItem.CanPickup(wallet);
                    case 0 -> WalletItem.CanExchange(wallet);
                    case 2 -> WalletItem.HasBankAccess(wallet);
                };
            }
            return false;
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.WALLET_ATTRIBUTE.get();
        }

        public String getTranslationKey() {
            return "lightmanscurrency.wallet_ability." + this.ability.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum AbilityType {
        EXCHANGE,
        PICKUP,
        BANK;

    }
}

