/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.patchouli;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.patchouli.api.IStyleStack;
import vazkii.patchouli.api.PatchouliAPI;

public class LCPatchouli {
    public static void init() {
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        api.registerFunction("lightmanscurrency_wallet_slots", LCPatchouli.buildWalletSizeFunction());
        api.registerFunction("lightmanscurrency_wallet_exchange", LCPatchouli.buildWalletFunction(WalletItem::CanExchange));
        api.registerFunction("lightmanscurrency_wallet_pickup", LCPatchouli.buildWalletFunction(WalletItem::CanPickup));
        api.registerFunction("lightmanscurrency_wallet_bank", LCPatchouli.buildWalletFunction(WalletItem::HasBankAccess));
        api.registerFunction("lightmanscurrency_wallet_magnet", LCPatchouli.buildWalletMagnetFunction());
        LightmansCurrency.LogDebug("Registered Custom Patchouli Functions!");
    }

    private static BiFunction<String, IStyleStack, String> buildWalletSizeFunction() {
        return (arg, style) -> {
            WalletItem wallet = LCPatchouli.getWallet(arg);
            if (wallet != null) {
                return String.valueOf(WalletItem.InventorySize(new ItemStack((ItemLike)wallet)));
            }
            return "0";
        };
    }

    private static BiFunction<String, IStyleStack, String> buildWalletFunction(Predicate<WalletItem> test) {
        return (arg, style) -> {
            String[] args = arg.split(";", 2);
            WalletItem wallet = LCPatchouli.getWallet(args[0]);
            if (wallet != null && test.test(wallet)) {
                return args[1];
            }
            return "";
        };
    }

    private static BiFunction<String, IStyleStack, String> buildWalletMagnetFunction() {
        return (arg, style) -> {
            ItemStack stack;
            int bonusLevels;
            WalletItem wallet = LCPatchouli.getWallet(arg);
            if (wallet != null && (bonusLevels = ((Integer)(stack = wallet.getDefaultInstance()).getOrDefault(ModDataComponents.WALLET_BONUS_MAGNET, (Object)0)).intValue()) > 0) {
                return String.valueOf(bonusLevels);
            }
            return "0";
        };
    }

    @Nullable
    private static WalletItem getWallet(String walletID) {
        ResourceLocation id = !walletID.contains("-") ? VersionUtil.lcResource(walletID) : VersionUtil.parseResource(walletID.replace("-", ":"));
        Object object = BuiltInRegistries.ITEM.get(id);
        if (object instanceof WalletItem) {
            WalletItem wallet = (WalletItem)((Object)object);
            return wallet;
        }
        return null;
    }
}

