/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.data;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.data.ClientCustomDataCache;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketSyncCustomData
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketSyncCustomData> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_sync_custom_data"));
    public static final CustomPacket.Handler<SPacketSyncCustomData> HANDLER = new H();
    private final ResourceLocation dataType;
    private final LazyPacketData data;

    public SPacketSyncCustomData(@Nonnull CustomDataType<?> type, @Nonnull LazyPacketData data) {
        this(LCRegistries.CUSTOM_DATA.getKey(type), data);
    }

    protected SPacketSyncCustomData(@Nonnull ResourceLocation dataType, @Nonnull LazyPacketData data) {
        super(TYPE);
        this.dataType = Objects.requireNonNull(dataType, "CustomDataType");
        this.data = data;
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull SPacketSyncCustomData message) {
        buffer.writeUtf(message.dataType.toString());
        message.data.encode(buffer);
    }

    private static SPacketSyncCustomData decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new SPacketSyncCustomData(VersionUtil.parseResource(buffer.readUtf()), LazyPacketData.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncCustomData> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(SPacketSyncCustomData::encode, SPacketSyncCustomData::decode));
        }

        @Override
        public void handle(@Nonnull SPacketSyncCustomData message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            CustomDataType type = (CustomDataType)LCRegistries.CUSTOM_DATA.get(message.dataType);
            if (type == null) {
                LightmansCurrency.LogWarning("Recieved sync packet for custom data of type '" + String.valueOf(message.dataType) + "' from the server, but no such data is registered on the client!");
                return;
            }
            Object data = ClientCustomDataCache.getData(type);
            if (data == null) {
                LightmansCurrency.LogError("Error getting client copy of the '" + String.valueOf(message.dataType) + "' custom data!");
                return;
            }
            ((CustomData)data).receivePacket(message.data);
        }
    }
}

